/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric.source;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.source.IoTDBNonDataRegionSource;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.manager.pipe.source.IoTDBConfigRegionSource;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigRegionSourceMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigRegionSourceMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, IoTDBConfigRegionSource> extractorMap = new ConcurrentHashMap<String, IoTDBConfigRegionSource>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.extractorMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String taskID) {
        this.createAutoGauge(taskID);
    }

    private void createAutoGauge(String taskID) {
        IoTDBConfigRegionSource extractor = this.extractorMap.get(taskID);
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_CONFIG_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.extractorMap.get(taskID), IoTDBNonDataRegionSource::getUnTransferredEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.extractorMap.keySet()).forEach(this::deregister);
        if (!this.extractorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe config region extractor metrics, extractor map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeAutoGauge(taskID);
    }

    private void removeAutoGauge(String taskID) {
        IoTDBConfigRegionSource extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_CONFIG_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    public void register(IoTDBConfigRegionSource extractor) {
        String taskID = extractor.getTaskID();
        this.extractorMap.putIfAbsent(taskID, extractor);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.extractorMap.containsKey(taskID)) {
            LOGGER.warn("Failed to deregister pipe config region extractor metrics, IoTDBConfigRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.extractorMap.remove(taskID);
    }

    public long getRemainingEventCount(String pipeName, long creationTime) {
        String taskID = pipeName + "_" + creationTime;
        IoTDBConfigRegionSource extractor = this.extractorMap.get(taskID);
        if (Objects.isNull((Object)extractor)) {
            return 0L;
        }
        return extractor.getUnTransferredEventCount();
    }

    public static PipeConfigRegionSourceMetrics getInstance() {
        return PipeConfigRegionSourceMetricsHolder.INSTANCE;
    }

    private PipeConfigRegionSourceMetrics() {
    }

    private static class PipeConfigRegionSourceMetricsHolder {
        private static final PipeConfigRegionSourceMetrics INSTANCE = new PipeConfigRegionSourceMetrics();

        private PipeConfigRegionSourceMetricsHolder() {
        }
    }
}

