/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.progress;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.agent.task.progress.interval.PipeCommitQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;

public class PipeEventCommitter {
    private final CommitterKey committerKey;
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final PipeCommitQueue commitQueue = new PipeCommitQueue();

    PipeEventCommitter(CommitterKey committerKey) {
        this.committerKey = committerKey;
    }

    public synchronized long generateCommitId() {
        return this.commitIdGenerator.incrementAndGet();
    }

    public synchronized void commit(EnrichedEvent event) {
        if (event.hasMultipleCommitIds()) {
            for (EnrichedEvent dummyEvent : event.getDummyEventsForCommitIds()) {
                this.commitQueue.offer(dummyEvent);
            }
        }
        this.commitQueue.offer(event);
    }

    public String getPipeName() {
        return this.committerKey.getPipeName();
    }

    public long getCreationTime() {
        return this.committerKey.getCreationTime();
    }

    public int getRegionId() {
        return this.committerKey.getRegionId();
    }

    public long commitQueueSize() {
        return this.commitQueue.size();
    }

    public long getCurrentCommitId() {
        return this.commitIdGenerator.get();
    }
}

