/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.receiver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.metric.SubscriptionPrefetchingQueueMetrics;
import org.apache.iotdb.db.subscription.receiver.SubscriptionReceiver;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.config.TopicConfig;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionPayloadExceedException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionPipeTimeoutException;
import org.apache.iotdb.rpc.subscription.payload.poll.PollFilePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.PollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.PollTabletsPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollRequest;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollRequestType;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeCloseReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeCommitReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeHandshakeReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeHeartbeatReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribePollReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeSubscribeReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeUnsubscribeReq;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeCloseResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeCommitResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeHandshakeResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeHeartbeatResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribePollResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeSubscribeResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeUnsubscribeResp;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.iotdb.session.subscription.util.PollTimer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionReceiverV1
implements SubscriptionReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionReceiverV1.class);
    private static final double POLL_PAYLOAD_SIZE_EXCEED_THRESHOLD = 0.9;
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final TPipeSubscribeResp SUBSCRIPTION_MISSING_CUSTOMER_RESP = new TPipeSubscribeResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_MISSING_CUSTOMER, (String)"Missing consumer config, please handshake first."), PipeSubscribeResponseVersion.VERSION_1.getVersion(), PipeSubscribeResponseType.ACK.getType());
    private final ThreadLocal<ConsumerConfig> consumerConfigThreadLocal = new ThreadLocal();
    private final ThreadLocal<PollTimer> pollTimerThreadLocal = new ThreadLocal();

    @Override
    public final TPipeSubscribeResp handle(TPipeSubscribeReq req) {
        short reqType = req.getType();
        if (PipeSubscribeRequestType.isValidatedRequestType((short)reqType)) {
            switch (PipeSubscribeRequestType.valueOf((short)reqType)) {
                case HANDSHAKE: {
                    return this.handlePipeSubscribeHandshake(PipeSubscribeHandshakeReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case HEARTBEAT: {
                    return this.handlePipeSubscribeHeartbeat(PipeSubscribeHeartbeatReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case SUBSCRIBE: {
                    return this.handlePipeSubscribeSubscribe(PipeSubscribeSubscribeReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case UNSUBSCRIBE: {
                    return this.handlePipeSubscribeUnsubscribe(PipeSubscribeUnsubscribeReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case POLL: {
                    return this.handlePipeSubscribePoll(PipeSubscribePollReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case COMMIT: {
                    return this.handlePipeSubscribeCommit(PipeSubscribeCommitReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case CLOSE: {
                    return this.handlePipeSubscribeClose(PipeSubscribeCloseReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
            }
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_TYPE_ERROR, (String)String.format("Unknown PipeSubscribeRequestType %s.", reqType));
        LOGGER.warn("Subscription: Unknown PipeSubscribeRequestType, response status = {}.", (Object)status);
        return new TPipeSubscribeResp(status, PipeSubscribeResponseVersion.VERSION_1.getVersion(), PipeSubscribeResponseType.ACK.getType());
    }

    @Override
    public PipeSubscribeRequestVersion getVersion() {
        return PipeSubscribeRequestVersion.VERSION_1;
    }

    @Override
    public void handleExit() {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.nonNull(consumerConfig)) {
            LOGGER.info("Subscription: remove consumer config {} when handling exit", (Object)this.consumerConfigThreadLocal.get());
            this.unsubscribeCompleteTopics(consumerConfig);
            this.consumerConfigThreadLocal.remove();
        }
    }

    @Override
    public long remainingMs() {
        PollTimer pollTimer = this.pollTimerThreadLocal.get();
        if (Objects.isNull(pollTimer)) {
            return SubscriptionConfig.getInstance().getSubscriptionDefaultTimeoutInMs();
        }
        pollTimer.update();
        return pollTimer.remainingMs();
    }

    private TPipeSubscribeResp handlePipeSubscribeHandshake(PipeSubscribeHandshakeReq req) {
        try {
            return this.handlePipeSubscribeHandshakeInternal(req);
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when handshaking with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when handshaking with request %s: %s", req, e);
            return PipeSubscribeHandshakeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_HANDSHAKE_ERROR, (String)exceptionMessage), (int)-1, (String)"", (String)"");
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeHandshakeInternal(PipeSubscribeHandshakeReq req) throws SubscriptionException {
        String consumerGroupId;
        ConsumerConfig existedConsumerConfig = this.consumerConfigThreadLocal.get();
        ConsumerConfig consumerConfig = req.getConsumerConfig();
        String consumerId = consumerConfig.getConsumerId();
        if (Objects.isNull(consumerId)) {
            consumerId = UUID.randomUUID().toString();
            consumerConfig.setConsumerId(consumerId);
        }
        if (Objects.isNull(consumerGroupId = consumerConfig.getConsumerGroupId())) {
            consumerGroupId = UUID.randomUUID().toString();
            consumerConfig.setConsumerGroupId(consumerGroupId);
        }
        if (Objects.isNull(existedConsumerConfig)) {
            this.consumerConfigThreadLocal.set(consumerConfig);
        } else if (!existedConsumerConfig.equals((Object)consumerConfig)) {
            LOGGER.warn("Subscription: Detect stale consumer config when handshaking, stale consumer config {} will be cleared, consumer config will set to the incoming consumer config {}.", (Object)existedConsumerConfig, (Object)consumerConfig);
            this.dropConsumer(existedConsumerConfig);
            this.consumerConfigThreadLocal.set(consumerConfig);
        }
        if (!SubscriptionAgent.consumer().isConsumerExisted(consumerGroupId, consumerId)) {
            this.createConsumer(consumerConfig);
        } else {
            LOGGER.info("Subscription: The consumer {} has already existed when handshaking, skip creating consumer.", (Object)consumerConfig);
        }
        int dataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
        LOGGER.info("Subscription: consumer {} handshake successfully, data node id: {}", (Object)req.getConsumerConfig(), (Object)dataNodeId);
        return PipeSubscribeHandshakeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, (int)dataNodeId, (String)consumerId, (String)consumerGroupId);
    }

    private TPipeSubscribeResp handlePipeSubscribeHeartbeat(PipeSubscribeHeartbeatReq req) {
        try {
            return this.handlePipeSubscribeHeartbeatInternal(req);
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when heartbeat with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when heartbeat with request %s: %s", req, e);
            return PipeSubscribeHeartbeatResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_HEARTBEAT_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeHeartbeatInternal(PipeSubscribeHeartbeatReq req) throws IOException {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeHeartbeatReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        LOGGER.info("Subscription: consumer {} heartbeat successfully", (Object)consumerConfig);
        Map<String, TopicConfig> topics = SubscriptionAgent.topic().getTopicConfigs(SubscriptionAgent.consumer().getTopicNamesSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId()));
        HashMap<Integer, TEndPoint> endPoints = new HashMap<Integer, TEndPoint>();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowDataNodesResp resp = configNodeClient.showDataNodes();
            for (TDataNodeInfo dataNodeInfo : resp.getDataNodesInfoList()) {
                if (Objects.equals(NodeStatus.Removing.getStatus(), dataNodeInfo.getStatus())) continue;
                String ip = dataNodeInfo.getRpcAddresss();
                int port = dataNodeInfo.getRpcPort();
                if (ip == null || port == 0) continue;
                endPoints.put(dataNodeInfo.getDataNodeId(), new TEndPoint(ip, port));
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("Exception occurred when fetch endpoints for consumer {} in config node", (Object)consumerConfig, (Object)e);
            String exceptionMessage = String.format("Subscription: Failed to fetch endpoints for consumer %s in config node, exception is %s.", consumerConfig, e);
            throw new SubscriptionException(exceptionMessage);
        }
        List<String> topicNamesToUnsubscribe = SubscriptionAgent.broker().fetchTopicNamesToUnsubscribe(consumerConfig, topics.keySet());
        return PipeSubscribeHeartbeatResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, topics, endPoints, topicNamesToUnsubscribe);
    }

    private TPipeSubscribeResp handlePipeSubscribeSubscribe(PipeSubscribeSubscribeReq req) {
        try {
            return this.handlePipeSubscribeSubscribeInternal(req);
        }
        catch (SubscriptionPipeTimeoutException e) {
            return PipeSubscribeSubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_PIPE_TIMEOUT_ERROR, (String)e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when subscribing with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when subscribing with request %s: %s", req, e);
            return PipeSubscribeSubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_SUBSCRIBE_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeSubscribeInternal(PipeSubscribeSubscribeReq req) throws SubscriptionException, IOException {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeSubscribeReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Set topicNames = req.getTopicNames();
        this.subscribe(consumerConfig, topicNames);
        LOGGER.info("Subscription: consumer {} subscribe {} successfully", (Object)consumerConfig, (Object)topicNames);
        return PipeSubscribeSubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, SubscriptionAgent.topic().getTopicConfigs(SubscriptionAgent.consumer().getTopicNamesSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId())));
    }

    private TPipeSubscribeResp handlePipeSubscribeUnsubscribe(PipeSubscribeUnsubscribeReq req) {
        try {
            return this.handlePipeSubscribeUnsubscribeInternal(req);
        }
        catch (SubscriptionPipeTimeoutException e) {
            return PipeSubscribeSubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_PIPE_TIMEOUT_ERROR, (String)e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when unsubscribing with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when unsubscribing with request %s: %s", req, e);
            return PipeSubscribeUnsubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_UNSUBSCRIBE_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeUnsubscribeInternal(PipeSubscribeUnsubscribeReq req) throws IOException {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeUnsubscribeReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Set topicNames = req.getTopicNames();
        this.unsubscribe(consumerConfig, topicNames);
        LOGGER.info("Subscription: consumer {} unsubscribe {} successfully", (Object)consumerConfig, (Object)topicNames);
        return PipeSubscribeUnsubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, SubscriptionAgent.topic().getTopicConfigs(SubscriptionAgent.consumer().getTopicNamesSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TPipeSubscribeResp handlePipeSubscribePoll(PipeSubscribePollReq req) {
        try {
            TPipeSubscribeResp tPipeSubscribeResp = this.handlePipeSubscribePollInternal(req);
            return tPipeSubscribeResp;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when polling with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when polling with request %s: %s", req, e);
            PipeSubscribePollResp pipeSubscribePollResp = PipeSubscribePollResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_POLL_ERROR, (String)exceptionMessage), Collections.emptyList());
            return pipeSubscribePollResp;
        }
        finally {
            this.pollTimerThreadLocal.remove();
        }
    }

    private TPipeSubscribeResp handlePipeSubscribePollInternal(PipeSubscribePollReq req) throws SubscriptionException {
        List<SubscriptionEvent> events;
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribePollReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        SubscriptionPollRequest request = req.getRequest();
        this.pollTimerThreadLocal.set(new PollTimer(System.currentTimeMillis(), request.getTimeoutMs()));
        long maxBytes = (long)((double)request.getMaxBytes() * 0.9);
        short requestType = request.getRequestType();
        if (SubscriptionPollRequestType.isValidatedRequestType((short)requestType)) {
            switch (SubscriptionPollRequestType.valueOf((short)requestType)) {
                case POLL: {
                    events = this.handlePipeSubscribePollRequest(consumerConfig, (PollPayload)request.getPayload(), maxBytes);
                    break;
                }
                case POLL_FILE: {
                    events = this.handlePipeSubscribePollTsFileRequest(consumerConfig, (PollFilePayload)request.getPayload());
                    break;
                }
                case POLL_TABLETS: {
                    events = this.handlePipeSubscribePollTabletsRequest(consumerConfig, (PollTabletsPayload)request.getPayload());
                    break;
                }
                default: {
                    events = null;
                    break;
                }
            }
        } else {
            events = null;
        }
        if (Objects.isNull(events)) {
            throw new SubscriptionException(String.format("unexpected request type: %s", requestType));
        }
        AtomicLong totalSize = new AtomicLong();
        return PipeSubscribePollResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, events.stream().map(event -> {
            SubscriptionCommitContext commitContext = event.getCommitContext();
            SubscriptionPollResponse response = event.getCurrentResponse();
            if (Objects.isNull(response)) {
                boolean isOutdated = SubscriptionAgent.broker().isCommitContextOutdated(event.getCommitContext());
                LOGGER.warn("Subscription: consumer {} poll null response for event {} (outdated: {}) with request: {}", new Object[]{consumerConfig, event, isOutdated, req.getRequest()});
                if (!isOutdated) {
                    SubscriptionAgent.broker().commit(consumerConfig, Collections.singletonList(commitContext), true);
                }
                return null;
            }
            try {
                ByteBuffer byteBuffer = event.getCurrentResponseByteBuffer();
                long size = event.getCurrentResponseSize();
                if (totalSize.get() + size > maxBytes) {
                    throw new SubscriptionPayloadExceedException(String.format("payload size %s byte(s) will exceed the threshold %s byte(s)", totalSize.get() + size, maxBytes));
                }
                totalSize.getAndAdd(size);
                SubscriptionPrefetchingQueueMetrics.getInstance().mark(SubscriptionPrefetchingQueue.generatePrefetchingQueueId(commitContext.getConsumerGroupId(), commitContext.getTopicName()), size);
                event.invalidateCurrentResponseByteBuffer();
                LOGGER.info("Subscription: consumer {} poll {} successfully with request: {}", new Object[]{consumerConfig, response, req.getRequest()});
                return byteBuffer;
            }
            catch (Exception e) {
                boolean isOutdated = SubscriptionAgent.broker().isCommitContextOutdated(event.getCommitContext());
                if (e instanceof SubscriptionPayloadExceedException) {
                    LOGGER.error("Subscription: consumer {} poll excessive payload {} for event {} (outdated: {}) with request: {}, something unexpected happened with parameter configuration or payload control...", new Object[]{consumerConfig, response, event, isOutdated, req.getRequest(), e});
                } else {
                    LOGGER.warn("Subscription: consumer {} poll {} for event {} (outdated: {}) failed with request: {}", new Object[]{consumerConfig, response, event, isOutdated, req.getRequest(), e});
                }
                if (!isOutdated) {
                    SubscriptionAgent.broker().commit(consumerConfig, Collections.singletonList(commitContext), true);
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private List<SubscriptionEvent> handlePipeSubscribePollRequest(ConsumerConfig consumerConfig, PollPayload messagePayload, long maxBytes) {
        Set<String> subscribedTopicNames = SubscriptionAgent.consumer().getTopicNamesSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId());
        Set topicNames = messagePayload.getTopicNames();
        if (topicNames.isEmpty()) {
            return Collections.emptyList();
        }
        topicNames.removeIf(topicName -> !subscribedTopicNames.contains(topicName));
        return SubscriptionAgent.broker().poll(consumerConfig, topicNames, maxBytes);
    }

    private List<SubscriptionEvent> handlePipeSubscribePollTsFileRequest(ConsumerConfig consumerConfig, PollFilePayload messagePayload) {
        return SubscriptionAgent.broker().pollTsFile(consumerConfig, messagePayload.getCommitContext(), messagePayload.getWritingOffset());
    }

    private List<SubscriptionEvent> handlePipeSubscribePollTabletsRequest(ConsumerConfig consumerConfig, PollTabletsPayload messagePayload) {
        return SubscriptionAgent.broker().pollTablets(consumerConfig, messagePayload.getCommitContext(), messagePayload.getOffset());
    }

    private TPipeSubscribeResp handlePipeSubscribeCommit(PipeSubscribeCommitReq req) {
        try {
            return this.handlePipeSubscribeCommitInternal(req);
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when committing with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when committing with request %s: %s", req, e);
            return PipeSubscribeCommitResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_COMMIT_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeCommitInternal(PipeSubscribeCommitReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeCommitReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        List commitContexts = req.getCommitContexts();
        boolean nack = req.isNack();
        List<SubscriptionCommitContext> successfulCommitContexts = SubscriptionAgent.broker().commit(consumerConfig, commitContexts, nack);
        if (Objects.equals(successfulCommitContexts.size(), commitContexts.size())) {
            LOGGER.info("Subscription: consumer {} commit (nack: {}) successfully, commit contexts: {}", new Object[]{consumerConfig, nack, commitContexts});
        } else {
            LOGGER.warn("Subscription: consumer {} commit (nack: {}) partially successful, commit contexts: {}, successful commit contexts: {}", new Object[]{consumerConfig, nack, commitContexts, successfulCommitContexts});
        }
        return PipeSubscribeCommitResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private TPipeSubscribeResp handlePipeSubscribeClose(PipeSubscribeCloseReq req) {
        try {
            return this.handlePipeSubscribeCloseInternal(req);
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when closing with request {}", (Object)req, (Object)e);
            String exceptionMessage = String.format("Subscription: something unexpected happened when closing with request %s: %s", req, e);
            return PipeSubscribeCloseResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_CLOSE_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeCloseInternal(PipeSubscribeCloseReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeCloseReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        this.closeConsumer(consumerConfig);
        return PipeSubscribeCloseResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private void closeConsumer(ConsumerConfig consumerConfig) {
        Set<String> topicNames = SubscriptionAgent.consumer().getTopicNamesSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId());
        if (!topicNames.isEmpty()) {
            LOGGER.info("Subscription: unsubscribe all subscribed topics {} before close consumer {}", topicNames, (Object)consumerConfig);
            try {
                this.unsubscribe(consumerConfig, topicNames);
            }
            catch (SubscriptionPipeTimeoutException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        if (SubscriptionAgent.consumer().isConsumerExisted(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId())) {
            this.dropConsumer(consumerConfig);
        } else {
            LOGGER.info("Subscription: The consumer {} does not existed when closing, skip dropping consumer.", (Object)consumerConfig);
        }
        LOGGER.info("Subscription: consumer {} close successfully", (Object)consumerConfig);
    }

    private void unsubscribeCompleteTopics(ConsumerConfig consumerConfig) {
        Map<String, TopicConfig> topics = SubscriptionAgent.topic().getTopicConfigs(SubscriptionAgent.consumer().getTopicNamesSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId()));
        List<String> topicNamesToUnsubscribe = SubscriptionAgent.broker().fetchTopicNamesToUnsubscribe(consumerConfig, topics.keySet());
        if (topicNamesToUnsubscribe.isEmpty()) {
            return;
        }
        this.unsubscribe(consumerConfig, new HashSet<String>(topicNamesToUnsubscribe));
        LOGGER.info("Subscription: consumer {} unsubscribe {} (completed topics) successfully", (Object)consumerConfig, topicNamesToUnsubscribe);
    }

    private void createConsumer(ConsumerConfig consumerConfig) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateConsumerReq req = new TCreateConsumerReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId()).setConsumerAttributes(consumerConfig.getAttribute());
            TSStatus tsStatus = configNodeClient.createConsumer(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Unexpected status code {} when creating consumer {} in config node", (Object)tsStatus, (Object)consumerConfig);
                String exceptionMessage = String.format("Subscription: Failed to create consumer %s in config node, status is %s.", consumerConfig, tsStatus);
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("Exception occurred when creating consumer {} in config node", (Object)consumerConfig, (Object)e);
            String exceptionMessage = String.format("Subscription: Failed to create consumer %s in config node, exception is %s.", consumerConfig, e);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    private void dropConsumer(ConsumerConfig consumerConfig) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCloseConsumerReq req = new TCloseConsumerReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId());
            TSStatus tsStatus = configNodeClient.closeConsumer(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Unexpected status code {} when closing consumer {} in config node", (Object)tsStatus, (Object)consumerConfig);
                String exceptionMessage = String.format("Subscription: Failed to close consumer %s in config node, status is %s.", consumerConfig, tsStatus);
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("Exception occurred when closing consumer {} in config node", (Object)consumerConfig, (Object)e);
            String exceptionMessage = String.format("Subscription: Failed to close consumer %s in config node, exception is %s.", consumerConfig, e);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    private void subscribe(ConsumerConfig consumerConfig, Set<String> topicNames) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSubscribeReq req = new TSubscribeReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId()).setTopicNames(topicNames);
            TSStatus tsStatus = configNodeClient.createSubscription(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Unexpected status code {} when subscribing topics {} for consumer {} in config node", new Object[]{tsStatus, topicNames, consumerConfig});
                String exceptionMessage = String.format("Subscription: Failed to subscribe topics %s for consumer %s in config node, status is %s.", topicNames, consumerConfig, tsStatus);
                if (TSStatusCode.SUBSCRIPTION_PIPE_TIMEOUT_ERROR.getStatusCode() == tsStatus.getCode()) {
                    throw new SubscriptionPipeTimeoutException(exceptionMessage);
                }
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("Exception occurred when subscribing topics {} for consumer {} in config node", new Object[]{topicNames, consumerConfig, e});
            String exceptionMessage = String.format("Subscription: Failed to subscribe topics %s for consumer %s in config node, exception is %s.", topicNames, consumerConfig, e);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    private void unsubscribe(ConsumerConfig consumerConfig, Set<String> topicNames) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TUnsubscribeReq req = new TUnsubscribeReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId()).setTopicNames(topicNames);
            TSStatus tsStatus = configNodeClient.dropSubscription(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Unexpected status code {} when unsubscribing topics {} for consumer {} in config node", new Object[]{tsStatus, topicNames, consumerConfig});
                String exceptionMessage = String.format("Subscription: Failed to unsubscribe topics %s for consumer %s in config node, status is %s.", topicNames, consumerConfig, tsStatus);
                if (TSStatusCode.SUBSCRIPTION_PIPE_TIMEOUT_ERROR.getStatusCode() == tsStatus.getCode()) {
                    throw new SubscriptionPipeTimeoutException(exceptionMessage);
                }
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("Exception occurred when unsubscribing topics {} for consumer {} in config node", new Object[]{topicNames, consumerConfig, e});
            String exceptionMessage = String.format("Subscription: Failed to unsubscribe topics %s for consumer %s in config node, exception is %s.", topicNames, consumerConfig, e);
            throw new SubscriptionException(exceptionMessage);
        }
    }
}

