/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryReadResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=638");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=640");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=639");
    private final StatusCode statusCode;
    private final ByteString continuationPoint;
    private final ExtensionObject historyData;

    public HistoryReadResult(StatusCode statusCode, ByteString continuationPoint, ExtensionObject historyData) {
        this.statusCode = statusCode;
        this.continuationPoint = continuationPoint;
        this.historyData = historyData;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public ExtensionObject getHistoryData() {
        return this.historyData;
    }

    protected HistoryReadResult(HistoryReadResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((HistoryReadResultBuilder)b).statusCode;
        this.continuationPoint = ((HistoryReadResultBuilder)b).continuationPoint;
        this.historyData = ((HistoryReadResultBuilder)b).historyData;
    }

    public static HistoryReadResultBuilder<?, ?> builder() {
        return new HistoryReadResultBuilderImpl();
    }

    public HistoryReadResultBuilder<?, ?> toBuilder() {
        return new HistoryReadResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryReadResult)) {
            return false;
        }
        HistoryReadResult other = (HistoryReadResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        ByteString this$continuationPoint = this.getContinuationPoint();
        ByteString other$continuationPoint = other.getContinuationPoint();
        if (this$continuationPoint == null ? other$continuationPoint != null : !((Object)this$continuationPoint).equals(other$continuationPoint)) {
            return false;
        }
        ExtensionObject this$historyData = this.getHistoryData();
        ExtensionObject other$historyData = other.getHistoryData();
        return !(this$historyData == null ? other$historyData != null : !((Object)this$historyData).equals(other$historyData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryReadResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        ByteString $continuationPoint = this.getContinuationPoint();
        result = result * 59 + ($continuationPoint == null ? 43 : ((Object)$continuationPoint).hashCode());
        ExtensionObject $historyData = this.getHistoryData();
        result = result * 59 + ($historyData == null ? 43 : ((Object)$historyData).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryReadResult(statusCode=" + this.getStatusCode() + ", continuationPoint=" + this.getContinuationPoint() + ", historyData=" + this.getHistoryData() + ")";
    }

    private static final class HistoryReadResultBuilderImpl
    extends HistoryReadResultBuilder<HistoryReadResult, HistoryReadResultBuilderImpl> {
        private HistoryReadResultBuilderImpl() {
        }

        @Override
        protected HistoryReadResultBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryReadResult build() {
            return new HistoryReadResult(this);
        }
    }

    public static abstract class HistoryReadResultBuilder<C extends HistoryReadResult, B extends HistoryReadResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private ByteString continuationPoint;
        private ExtensionObject historyData;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryReadResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryReadResult instance, HistoryReadResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.continuationPoint(instance.continuationPoint);
            b.historyData(instance.historyData);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B continuationPoint(ByteString continuationPoint) {
            this.continuationPoint = continuationPoint;
            return (B)this.self();
        }

        public B historyData(ExtensionObject historyData) {
            this.historyData = historyData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryReadResult.HistoryReadResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", continuationPoint=" + this.continuationPoint + ", historyData=" + this.historyData + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryReadResult> {
        @Override
        public Class<HistoryReadResult> getType() {
            return HistoryReadResult.class;
        }

        @Override
        public HistoryReadResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ExtensionObject historyData = decoder.readExtensionObject("HistoryData");
            return new HistoryReadResult(statusCode, continuationPoint, historyData);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryReadResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
            encoder.writeExtensionObject("HistoryData", value.getHistoryData());
        }
    }
}

