/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCertificateManager
implements CertificateManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ByteString, KeyPair> privateKeys = new HashMap<ByteString, KeyPair>();
    private final Map<ByteString, X509Certificate[]> certificates = new HashMap<ByteString, X509Certificate[]>();

    public DefaultCertificateManager() {
    }

    public DefaultCertificateManager(KeyPair keyPair, X509Certificate certificate) {
        Preconditions.checkNotNull((Object)keyPair, (Object)"keyPair must be non-null");
        Preconditions.checkNotNull((Object)certificate, (Object)"certificate must be non-null");
        this.add(keyPair, certificate);
    }

    public DefaultCertificateManager(KeyPair keyPair, X509Certificate[] certificateChain) {
        Preconditions.checkNotNull((Object)keyPair, (Object)"keyPair must be non-null");
        Preconditions.checkNotNull((Object)certificateChain, (Object)"certificateChain must be non-null");
        this.add(keyPair, certificateChain);
    }

    public synchronized void add(KeyPair keyPair, X509Certificate certificate) {
        this.add(keyPair, new X509Certificate[]{certificate});
    }

    public synchronized void add(KeyPair keyPair, X509Certificate[] certificateChain) {
        Preconditions.checkNotNull((Object)keyPair, (Object)"keyPair must be non-null");
        Preconditions.checkNotNull((Object)certificateChain, (Object)"certificateChain must be non-null");
        try {
            X509Certificate certificate = certificateChain[0];
            ByteString thumbprint = ByteString.of(DigestUtil.sha1(certificate.getEncoded()));
            this.privateKeys.put(thumbprint, keyPair);
            this.certificates.put(thumbprint, certificateChain);
        }
        catch (CertificateEncodingException e) {
            this.logger.error("Error getting certificate thumbprint.", (Throwable)e);
        }
    }

    public synchronized void remove(ByteString thumbprint) {
        this.privateKeys.remove(thumbprint);
        this.certificates.remove(thumbprint);
    }

    public synchronized void replace(ByteString thumbprint, KeyPair keyPair, X509Certificate[] certificateChain) {
        this.remove(thumbprint);
        this.add(keyPair, certificateChain);
    }

    @Override
    public synchronized Optional<KeyPair> getKeyPair(ByteString thumbprint) {
        return Optional.ofNullable(this.privateKeys.get(thumbprint));
    }

    @Override
    public synchronized Optional<X509Certificate> getCertificate(ByteString thumbprint) {
        X509Certificate[] chain = this.certificates.get(thumbprint);
        if (chain != null && chain.length > 0) {
            return Optional.of(chain[0]);
        }
        return Optional.empty();
    }

    @Override
    public synchronized Optional<X509Certificate[]> getCertificateChain(ByteString thumbprint) {
        return Optional.ofNullable(this.certificates.get(thumbprint));
    }

    @Override
    public synchronized Set<KeyPair> getKeyPairs() {
        return Sets.newHashSet(this.privateKeys.values());
    }

    @Override
    public synchronized Set<X509Certificate> getCertificates() {
        return this.certificates.values().stream().map(a -> a[0]).collect(Collectors.toSet());
    }
}

