/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ReferenceNode
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=285");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=287");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=286");
    private final NodeId referenceTypeId;
    private final Boolean isInverse;
    private final ExpandedNodeId targetId;

    public ReferenceNode(NodeId referenceTypeId, Boolean isInverse, ExpandedNodeId targetId) {
        this.referenceTypeId = referenceTypeId;
        this.isInverse = isInverse;
        this.targetId = targetId;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsInverse() {
        return this.isInverse;
    }

    public ExpandedNodeId getTargetId() {
        return this.targetId;
    }

    protected ReferenceNode(ReferenceNodeBuilder<?, ?> b) {
        super(b);
        this.referenceTypeId = ((ReferenceNodeBuilder)b).referenceTypeId;
        this.isInverse = ((ReferenceNodeBuilder)b).isInverse;
        this.targetId = ((ReferenceNodeBuilder)b).targetId;
    }

    public static ReferenceNodeBuilder<?, ?> builder() {
        return new ReferenceNodeBuilderImpl();
    }

    public ReferenceNodeBuilder<?, ?> toBuilder() {
        return new ReferenceNodeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceNode)) {
            return false;
        }
        ReferenceNode other = (ReferenceNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isInverse = this.getIsInverse();
        Boolean other$isInverse = other.getIsInverse();
        if (this$isInverse == null ? other$isInverse != null : !((Object)this$isInverse).equals(other$isInverse)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        ExpandedNodeId this$targetId = this.getTargetId();
        ExpandedNodeId other$targetId = other.getTargetId();
        return !(this$targetId == null ? other$targetId != null : !((Object)this$targetId).equals(other$targetId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferenceNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isInverse = this.getIsInverse();
        result = result * 59 + ($isInverse == null ? 43 : ((Object)$isInverse).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        ExpandedNodeId $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : ((Object)$targetId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReferenceNode(referenceTypeId=" + this.getReferenceTypeId() + ", isInverse=" + this.getIsInverse() + ", targetId=" + this.getTargetId() + ")";
    }

    private static final class ReferenceNodeBuilderImpl
    extends ReferenceNodeBuilder<ReferenceNode, ReferenceNodeBuilderImpl> {
        private ReferenceNodeBuilderImpl() {
        }

        @Override
        protected ReferenceNodeBuilderImpl self() {
            return this;
        }

        @Override
        public ReferenceNode build() {
            return new ReferenceNode(this);
        }
    }

    public static abstract class ReferenceNodeBuilder<C extends ReferenceNode, B extends ReferenceNodeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId referenceTypeId;
        private Boolean isInverse;
        private ExpandedNodeId targetId;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReferenceNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReferenceNode instance, ReferenceNodeBuilder<?, ?> b) {
            b.referenceTypeId(instance.referenceTypeId);
            b.isInverse(instance.isInverse);
            b.targetId(instance.targetId);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B isInverse(Boolean isInverse) {
            this.isInverse = isInverse;
            return (B)this.self();
        }

        public B targetId(ExpandedNodeId targetId) {
            this.targetId = targetId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReferenceNode.ReferenceNodeBuilder(super=" + super.toString() + ", referenceTypeId=" + this.referenceTypeId + ", isInverse=" + this.isInverse + ", targetId=" + this.targetId + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReferenceNode> {
        @Override
        public Class<ReferenceNode> getType() {
            return ReferenceNode.class;
        }

        @Override
        public ReferenceNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isInverse = decoder.readBoolean("IsInverse");
            ExpandedNodeId targetId = decoder.readExpandedNodeId("TargetId");
            return new ReferenceNode(referenceTypeId, isInverse, targetId);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReferenceNode value) {
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IsInverse", value.getIsInverse());
            encoder.writeExpandedNodeId("TargetId", value.getTargetId());
        }
    }
}

