/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.payload.thrift.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferFilePieceResp
extends TPipeTransferResp {
    public static final long ERROR_END_OFFSET = -1L;
    private long endWritingOffset;

    private PipeTransferFilePieceResp() {
    }

    public long getEndWritingOffset() {
        return this.endWritingOffset;
    }

    public static PipeTransferFilePieceResp toTPipeTransferResp(TSStatus status, long endWritingOffset) throws IOException {
        PipeTransferFilePieceResp filePieceResp = new PipeTransferFilePieceResp();
        filePieceResp.status = status;
        filePieceResp.endWritingOffset = endWritingOffset;
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((long)endWritingOffset, (OutputStream)outputStream);
            filePieceResp.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return filePieceResp;
    }

    public static PipeTransferFilePieceResp toTPipeTransferResp(TSStatus status) {
        PipeTransferFilePieceResp filePieceResp = new PipeTransferFilePieceResp();
        filePieceResp.status = status;
        return filePieceResp;
    }

    public static PipeTransferFilePieceResp fromTPipeTransferResp(TPipeTransferResp transferResp) {
        PipeTransferFilePieceResp filePieceResp = new PipeTransferFilePieceResp();
        filePieceResp.status = transferResp.status;
        if (transferResp.isSetBody()) {
            filePieceResp.endWritingOffset = ReadWriteIOUtils.readLong((ByteBuffer)transferResp.body);
            filePieceResp.body = transferResp.body;
        }
        return filePieceResp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferFilePieceResp that = (PipeTransferFilePieceResp)((Object)obj);
        return this.endWritingOffset == that.endWritingOffset && this.status.equals(that.status) && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.endWritingOffset, this.status, this.body);
    }
}

