/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.unary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IsNullViewExpression
extends UnaryViewExpression {
    private final boolean isNot;

    public IsNullViewExpression(ViewExpression expression, boolean isNot) {
        super(expression);
        this.isNot = isNot;
    }

    public IsNullViewExpression(ByteBuffer byteBuffer) {
        super(ViewExpression.deserialize(byteBuffer));
        this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public IsNullViewExpression(InputStream inputStream) {
        super(ViewExpression.deserialize(inputStream));
        try {
            this.isNot = ReadWriteIOUtils.readBool((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitIsNullExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.IS_NULL;
    }

    @Override
    public String toString(boolean isRoot) {
        return this.expression.toString(false) + " IS_NULL";
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    public boolean isNot() {
        return this.isNot;
    }
}

