/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.common.regexp;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.tsfile.common.regexp.DenseDfaMatcher;
import org.apache.tsfile.common.regexp.FjsMatcher;
import org.apache.tsfile.common.regexp.Matcher;
import org.apache.tsfile.common.regexp.NfaMatcher;
import org.apache.tsfile.common.regexp.pattern.Any;
import org.apache.tsfile.common.regexp.pattern.Literal;
import org.apache.tsfile.common.regexp.pattern.Pattern;
import org.apache.tsfile.common.regexp.pattern.ZeroOrMore;

public class LikeMatcher {
    private final int minSize;
    private final OptionalInt maxSize;
    private final byte[] prefix;
    private final byte[] suffix;
    private final Optional<Matcher> matcher;

    private LikeMatcher(int minSize, OptionalInt maxSize, byte[] prefix, byte[] suffix, Optional<Matcher> matcher) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.prefix = prefix;
        this.suffix = suffix;
        this.matcher = matcher;
    }

    public static LikeMatcher compile(String pattern) {
        return LikeMatcher.compile(pattern, Optional.empty(), true);
    }

    public static LikeMatcher compile(String pattern, Optional<Character> escape) {
        return LikeMatcher.compile(pattern, escape, true);
    }

    public static LikeMatcher compile(String pattern, Optional<Character> escape, boolean optimize) {
        Literal literal;
        List<Pattern> parsed = LikeMatcher.parse(pattern, escape);
        int minSize = 0;
        int maxSize = 0;
        boolean unbounded = false;
        for (Pattern expression : parsed) {
            int length;
            if (expression instanceof Literal) {
                Literal literal2 = (Literal)expression;
                length = literal2.getValue().getBytes(StandardCharsets.UTF_8).length;
                minSize += length;
                maxSize += length;
                continue;
            }
            if (expression instanceof ZeroOrMore) {
                unbounded = true;
                continue;
            }
            if (!(expression instanceof Any)) continue;
            Any any = (Any)expression;
            length = any.getLength();
            minSize += length;
            maxSize += length * 4;
        }
        byte[] prefix = new byte[]{};
        byte[] suffix = new byte[]{};
        int patternStart = 0;
        int patternEnd = parsed.size() - 1;
        if (parsed.size() > 0 && parsed.get(0) instanceof Literal) {
            literal = (Literal)parsed.get(0);
            prefix = literal.getValue().getBytes(StandardCharsets.UTF_8);
            ++patternStart;
        }
        if (parsed.size() > 1 && parsed.get(parsed.size() - 1) instanceof Literal) {
            literal = (Literal)parsed.get(parsed.size() - 1);
            suffix = literal.getValue().getBytes(StandardCharsets.UTF_8);
            --patternEnd;
        }
        boolean exact = true;
        if (patternStart <= patternEnd && parsed.get(patternEnd) instanceof ZeroOrMore) {
            exact = false;
            --patternEnd;
        }
        Optional<Matcher> matcher = Optional.empty();
        if (patternStart <= patternEnd) {
            boolean hasAny = false;
            for (int i = patternStart; i <= patternEnd; ++i) {
                Pattern item = parsed.get(i);
                if (!(item instanceof Any)) continue;
                hasAny = true;
                break;
            }
            matcher = hasAny ? (optimize ? Optional.of(new DenseDfaMatcher(parsed, patternStart, patternEnd, exact)) : Optional.of(new NfaMatcher(parsed, patternStart, patternEnd, exact))) : Optional.of(new FjsMatcher(parsed, patternStart, patternEnd, exact));
        }
        return new LikeMatcher(minSize, unbounded ? OptionalInt.empty() : OptionalInt.of(maxSize), prefix, suffix, matcher);
    }

    public boolean match(byte[] input) {
        return this.match(input, 0, input.length);
    }

    public boolean match(byte[] input, int offset, int length) {
        if (length < this.minSize) {
            return false;
        }
        if (this.maxSize.isPresent() && length > this.maxSize.getAsInt()) {
            return false;
        }
        if (!this.startsWith(this.prefix, input, offset)) {
            return false;
        }
        if (!this.startsWith(this.suffix, input, offset + length - this.suffix.length)) {
            return false;
        }
        if (this.matcher.isPresent()) {
            return this.matcher.get().match(input, offset + this.prefix.length, length - this.suffix.length - this.prefix.length);
        }
        return true;
    }

    private boolean startsWith(byte[] pattern, byte[] input, int offset) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == input[offset + i]) continue;
            return false;
        }
        return true;
    }

    static List<Pattern> parse(String pattern, Optional<Character> escape) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        StringBuilder literal = new StringBuilder();
        int anyCount = 0;
        boolean anyUnbounded = false;
        boolean inEscape = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (inEscape) {
                if (character != '%' && character != '_' && character != escape.get().charValue()) {
                    throw new IllegalArgumentException("Escape character must be followed by '%', '_' or the escape character itself");
                }
                literal.append(character);
                inEscape = false;
                continue;
            }
            if (escape.isPresent() && character == escape.get().charValue()) {
                inEscape = true;
                if (anyCount != 0) {
                    result.add(new Any(anyCount));
                    anyCount = 0;
                }
                if (!anyUnbounded) continue;
                result.add(new ZeroOrMore());
                anyUnbounded = false;
                continue;
            }
            if (character == '%' || character == '_') {
                if (literal.length() != 0) {
                    result.add(new Literal(literal.toString()));
                    literal.setLength(0);
                }
                if (character == '%') {
                    anyUnbounded = true;
                    continue;
                }
                ++anyCount;
                continue;
            }
            if (anyCount != 0) {
                result.add(new Any(anyCount));
                anyCount = 0;
            }
            if (anyUnbounded) {
                result.add(new ZeroOrMore());
                anyUnbounded = false;
            }
            literal.append(character);
        }
        if (inEscape) {
            throw new IllegalArgumentException("Escape character must be followed by '%', '_' or the escape character itself");
        }
        if (literal.length() != 0) {
            result.add(new Literal(literal.toString()));
        } else {
            if (anyCount != 0) {
                result.add(new Any(anyCount));
            }
            if (anyUnbounded) {
                result.add(new ZeroOrMore());
            }
        }
        return result;
    }
}

