/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AddNodesItem
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=376");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=377");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=378");
    private final ExpandedNodeId parentNodeId;
    private final NodeId referenceTypeId;
    private final ExpandedNodeId requestedNewNodeId;
    private final QualifiedName browseName;
    private final NodeClass nodeClass;
    private final ExtensionObject nodeAttributes;
    private final ExpandedNodeId typeDefinition;

    public AddNodesItem(ExpandedNodeId parentNodeId, NodeId referenceTypeId, ExpandedNodeId requestedNewNodeId, QualifiedName browseName, NodeClass nodeClass, ExtensionObject nodeAttributes, ExpandedNodeId typeDefinition) {
        this.parentNodeId = parentNodeId;
        this.referenceTypeId = referenceTypeId;
        this.requestedNewNodeId = requestedNewNodeId;
        this.browseName = browseName;
        this.nodeClass = nodeClass;
        this.nodeAttributes = nodeAttributes;
        this.typeDefinition = typeDefinition;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ExpandedNodeId getParentNodeId() {
        return this.parentNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public ExpandedNodeId getRequestedNewNodeId() {
        return this.requestedNewNodeId;
    }

    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    public NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public ExtensionObject getNodeAttributes() {
        return this.nodeAttributes;
    }

    public ExpandedNodeId getTypeDefinition() {
        return this.typeDefinition;
    }

    protected AddNodesItem(AddNodesItemBuilder<?, ?> b) {
        super(b);
        this.parentNodeId = ((AddNodesItemBuilder)b).parentNodeId;
        this.referenceTypeId = ((AddNodesItemBuilder)b).referenceTypeId;
        this.requestedNewNodeId = ((AddNodesItemBuilder)b).requestedNewNodeId;
        this.browseName = ((AddNodesItemBuilder)b).browseName;
        this.nodeClass = ((AddNodesItemBuilder)b).nodeClass;
        this.nodeAttributes = ((AddNodesItemBuilder)b).nodeAttributes;
        this.typeDefinition = ((AddNodesItemBuilder)b).typeDefinition;
    }

    public static AddNodesItemBuilder<?, ?> builder() {
        return new AddNodesItemBuilderImpl();
    }

    public AddNodesItemBuilder<?, ?> toBuilder() {
        return new AddNodesItemBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddNodesItem)) {
            return false;
        }
        AddNodesItem other = (AddNodesItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExpandedNodeId this$parentNodeId = this.getParentNodeId();
        ExpandedNodeId other$parentNodeId = other.getParentNodeId();
        if (this$parentNodeId == null ? other$parentNodeId != null : !((Object)this$parentNodeId).equals(other$parentNodeId)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        ExpandedNodeId this$requestedNewNodeId = this.getRequestedNewNodeId();
        ExpandedNodeId other$requestedNewNodeId = other.getRequestedNewNodeId();
        if (this$requestedNewNodeId == null ? other$requestedNewNodeId != null : !((Object)this$requestedNewNodeId).equals(other$requestedNewNodeId)) {
            return false;
        }
        QualifiedName this$browseName = this.getBrowseName();
        QualifiedName other$browseName = other.getBrowseName();
        if (this$browseName == null ? other$browseName != null : !((Object)this$browseName).equals(other$browseName)) {
            return false;
        }
        NodeClass this$nodeClass = this.getNodeClass();
        NodeClass other$nodeClass = other.getNodeClass();
        if (this$nodeClass == null ? other$nodeClass != null : !this$nodeClass.equals(other$nodeClass)) {
            return false;
        }
        ExtensionObject this$nodeAttributes = this.getNodeAttributes();
        ExtensionObject other$nodeAttributes = other.getNodeAttributes();
        if (this$nodeAttributes == null ? other$nodeAttributes != null : !((Object)this$nodeAttributes).equals(other$nodeAttributes)) {
            return false;
        }
        ExpandedNodeId this$typeDefinition = this.getTypeDefinition();
        ExpandedNodeId other$typeDefinition = other.getTypeDefinition();
        return !(this$typeDefinition == null ? other$typeDefinition != null : !((Object)this$typeDefinition).equals(other$typeDefinition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddNodesItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpandedNodeId $parentNodeId = this.getParentNodeId();
        result = result * 59 + ($parentNodeId == null ? 43 : ((Object)$parentNodeId).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        ExpandedNodeId $requestedNewNodeId = this.getRequestedNewNodeId();
        result = result * 59 + ($requestedNewNodeId == null ? 43 : ((Object)$requestedNewNodeId).hashCode());
        QualifiedName $browseName = this.getBrowseName();
        result = result * 59 + ($browseName == null ? 43 : ((Object)$browseName).hashCode());
        NodeClass $nodeClass = this.getNodeClass();
        result = result * 59 + ($nodeClass == null ? 43 : $nodeClass.hashCode());
        ExtensionObject $nodeAttributes = this.getNodeAttributes();
        result = result * 59 + ($nodeAttributes == null ? 43 : ((Object)$nodeAttributes).hashCode());
        ExpandedNodeId $typeDefinition = this.getTypeDefinition();
        result = result * 59 + ($typeDefinition == null ? 43 : ((Object)$typeDefinition).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AddNodesItem(parentNodeId=" + this.getParentNodeId() + ", referenceTypeId=" + this.getReferenceTypeId() + ", requestedNewNodeId=" + this.getRequestedNewNodeId() + ", browseName=" + this.getBrowseName() + ", nodeClass=" + this.getNodeClass() + ", nodeAttributes=" + this.getNodeAttributes() + ", typeDefinition=" + this.getTypeDefinition() + ")";
    }

    private static final class AddNodesItemBuilderImpl
    extends AddNodesItemBuilder<AddNodesItem, AddNodesItemBuilderImpl> {
        private AddNodesItemBuilderImpl() {
        }

        @Override
        protected AddNodesItemBuilderImpl self() {
            return this;
        }

        @Override
        public AddNodesItem build() {
            return new AddNodesItem(this);
        }
    }

    public static abstract class AddNodesItemBuilder<C extends AddNodesItem, B extends AddNodesItemBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ExpandedNodeId parentNodeId;
        private NodeId referenceTypeId;
        private ExpandedNodeId requestedNewNodeId;
        private QualifiedName browseName;
        private NodeClass nodeClass;
        private ExtensionObject nodeAttributes;
        private ExpandedNodeId typeDefinition;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AddNodesItemBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AddNodesItem instance, AddNodesItemBuilder<?, ?> b) {
            b.parentNodeId(instance.parentNodeId);
            b.referenceTypeId(instance.referenceTypeId);
            b.requestedNewNodeId(instance.requestedNewNodeId);
            b.browseName(instance.browseName);
            b.nodeClass(instance.nodeClass);
            b.nodeAttributes(instance.nodeAttributes);
            b.typeDefinition(instance.typeDefinition);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B parentNodeId(ExpandedNodeId parentNodeId) {
            this.parentNodeId = parentNodeId;
            return (B)this.self();
        }

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B requestedNewNodeId(ExpandedNodeId requestedNewNodeId) {
            this.requestedNewNodeId = requestedNewNodeId;
            return (B)this.self();
        }

        public B browseName(QualifiedName browseName) {
            this.browseName = browseName;
            return (B)this.self();
        }

        public B nodeClass(NodeClass nodeClass) {
            this.nodeClass = nodeClass;
            return (B)this.self();
        }

        public B nodeAttributes(ExtensionObject nodeAttributes) {
            this.nodeAttributes = nodeAttributes;
            return (B)this.self();
        }

        public B typeDefinition(ExpandedNodeId typeDefinition) {
            this.typeDefinition = typeDefinition;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AddNodesItem.AddNodesItemBuilder(super=" + super.toString() + ", parentNodeId=" + this.parentNodeId + ", referenceTypeId=" + this.referenceTypeId + ", requestedNewNodeId=" + this.requestedNewNodeId + ", browseName=" + this.browseName + ", nodeClass=" + this.nodeClass + ", nodeAttributes=" + this.nodeAttributes + ", typeDefinition=" + this.typeDefinition + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AddNodesItem> {
        @Override
        public Class<AddNodesItem> getType() {
            return AddNodesItem.class;
        }

        @Override
        public AddNodesItem decode(SerializationContext context, UaDecoder decoder) {
            ExpandedNodeId parentNodeId = decoder.readExpandedNodeId("ParentNodeId");
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            ExpandedNodeId requestedNewNodeId = decoder.readExpandedNodeId("RequestedNewNodeId");
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            ExtensionObject nodeAttributes = decoder.readExtensionObject("NodeAttributes");
            ExpandedNodeId typeDefinition = decoder.readExpandedNodeId("TypeDefinition");
            return new AddNodesItem(parentNodeId, referenceTypeId, requestedNewNodeId, browseName, nodeClass, nodeAttributes, typeDefinition);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AddNodesItem value) {
            encoder.writeExpandedNodeId("ParentNodeId", value.getParentNodeId());
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeExpandedNodeId("RequestedNewNodeId", value.getRequestedNewNodeId());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeExtensionObject("NodeAttributes", value.getNodeAttributes());
            encoder.writeExpandedNodeId("TypeDefinition", value.getTypeDefinition());
        }
    }
}

