/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;

public class ElementOperand
extends FilterOperand
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=592");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=593");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=594");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15207");
    private final UInteger index;

    public ElementOperand(UInteger index) {
        this.index = index;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public UInteger getIndex() {
        return this.index;
    }

    protected ElementOperand(ElementOperandBuilder<?, ?> b) {
        super((FilterOperand.FilterOperandBuilder<?, ?>)b);
        this.index = ((ElementOperandBuilder)b).index;
    }

    public static ElementOperandBuilder<?, ?> builder() {
        return new ElementOperandBuilderImpl();
    }

    public ElementOperandBuilder<?, ?> toBuilder() {
        return new ElementOperandBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementOperand)) {
            return false;
        }
        ElementOperand other = (ElementOperand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UInteger this$index = this.getIndex();
        UInteger other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !((Object)this$index).equals(other$index));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ElementOperand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UInteger $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ElementOperand(index=" + this.getIndex() + ")";
    }

    private static final class ElementOperandBuilderImpl
    extends ElementOperandBuilder<ElementOperand, ElementOperandBuilderImpl> {
        private ElementOperandBuilderImpl() {
        }

        @Override
        protected ElementOperandBuilderImpl self() {
            return this;
        }

        @Override
        public ElementOperand build() {
            return new ElementOperand(this);
        }
    }

    public static abstract class ElementOperandBuilder<C extends ElementOperand, B extends ElementOperandBuilder<C, B>>
    extends FilterOperand.FilterOperandBuilder<C, B> {
        private UInteger index;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ElementOperandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ElementOperand instance, ElementOperandBuilder<?, ?> b) {
            b.index(instance.index);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B index(UInteger index) {
            this.index = index;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ElementOperand.ElementOperandBuilder(super=" + super.toString() + ", index=" + this.index + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ElementOperand> {
        @Override
        public Class<ElementOperand> getType() {
            return ElementOperand.class;
        }

        @Override
        public ElementOperand decode(SerializationContext context, UaDecoder decoder) {
            UInteger index = decoder.readUInt32("Index");
            return new ElementOperand(index);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ElementOperand value) {
            encoder.writeUInt32("Index", value.getIndex());
        }
    }
}

