/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PerformUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class UpdateDataDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=680");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=682");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=681");
    private final PerformUpdateType performInsertReplace;
    private final DataValue[] updateValues;

    public UpdateDataDetails(NodeId nodeId, PerformUpdateType performInsertReplace, DataValue[] updateValues) {
        super(nodeId);
        this.performInsertReplace = performInsertReplace;
        this.updateValues = updateValues;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public PerformUpdateType getPerformInsertReplace() {
        return this.performInsertReplace;
    }

    public DataValue[] getUpdateValues() {
        return this.updateValues;
    }

    protected UpdateDataDetails(UpdateDataDetailsBuilder<?, ?> b) {
        super((HistoryUpdateDetails.HistoryUpdateDetailsBuilder<?, ?>)b);
        this.performInsertReplace = ((UpdateDataDetailsBuilder)b).performInsertReplace;
        this.updateValues = ((UpdateDataDetailsBuilder)b).updateValues;
    }

    public static UpdateDataDetailsBuilder<?, ?> builder() {
        return new UpdateDataDetailsBuilderImpl();
    }

    public UpdateDataDetailsBuilder<?, ?> toBuilder() {
        return new UpdateDataDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateDataDetails)) {
            return false;
        }
        UpdateDataDetails other = (UpdateDataDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PerformUpdateType this$performInsertReplace = this.getPerformInsertReplace();
        PerformUpdateType other$performInsertReplace = other.getPerformInsertReplace();
        if (this$performInsertReplace == null ? other$performInsertReplace != null : !this$performInsertReplace.equals(other$performInsertReplace)) {
            return false;
        }
        return Arrays.deepEquals(this.getUpdateValues(), other.getUpdateValues());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateDataDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PerformUpdateType $performInsertReplace = this.getPerformInsertReplace();
        result = result * 59 + ($performInsertReplace == null ? 43 : $performInsertReplace.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUpdateValues());
        return result;
    }

    @Override
    public String toString() {
        return "UpdateDataDetails(performInsertReplace=" + this.getPerformInsertReplace() + ", updateValues=" + Arrays.deepToString(this.getUpdateValues()) + ")";
    }

    private static final class UpdateDataDetailsBuilderImpl
    extends UpdateDataDetailsBuilder<UpdateDataDetails, UpdateDataDetailsBuilderImpl> {
        private UpdateDataDetailsBuilderImpl() {
        }

        @Override
        protected UpdateDataDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public UpdateDataDetails build() {
            return new UpdateDataDetails(this);
        }
    }

    public static abstract class UpdateDataDetailsBuilder<C extends UpdateDataDetails, B extends UpdateDataDetailsBuilder<C, B>>
    extends HistoryUpdateDetails.HistoryUpdateDetailsBuilder<C, B> {
        private PerformUpdateType performInsertReplace;
        private DataValue[] updateValues;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UpdateDataDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(UpdateDataDetails instance, UpdateDataDetailsBuilder<?, ?> b) {
            b.performInsertReplace(instance.performInsertReplace);
            b.updateValues(instance.updateValues);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B performInsertReplace(PerformUpdateType performInsertReplace) {
            this.performInsertReplace = performInsertReplace;
            return (B)this.self();
        }

        public B updateValues(DataValue[] updateValues) {
            this.updateValues = updateValues;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UpdateDataDetails.UpdateDataDetailsBuilder(super=" + super.toString() + ", performInsertReplace=" + this.performInsertReplace + ", updateValues=" + Arrays.deepToString(this.updateValues) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<UpdateDataDetails> {
        @Override
        public Class<UpdateDataDetails> getType() {
            return UpdateDataDetails.class;
        }

        @Override
        public UpdateDataDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            PerformUpdateType performInsertReplace = decoder.readEnum("PerformInsertReplace", PerformUpdateType.class);
            DataValue[] updateValues = decoder.readDataValueArray("UpdateValues");
            return new UpdateDataDetails(nodeId, performInsertReplace, updateValues);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UpdateDataDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("PerformInsertReplace", value.getPerformInsertReplace());
            encoder.writeDataValueArray("UpdateValues", value.getUpdateValues());
        }
    }
}

