/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util.validation;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaCertificateRevocationChecker
extends PKIXRevocationChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaCertificateRevocationChecker.class);
    private final PKIXRevocationChecker checker;
    private final CertPath certPath;
    private final TrustAnchor trustAnchor;
    private final PKIXParameters parameters;
    private final Set<ValidationCheck> validationChecks;

    public OpcUaCertificateRevocationChecker(CertPath certPath, TrustAnchor trustAnchor, PKIXParameters parameters, Set<ValidationCheck> validationChecks) throws Exception {
        this.certPath = certPath;
        this.trustAnchor = trustAnchor;
        this.parameters = parameters;
        this.validationChecks = validationChecks;
        HashSet options = Sets.newHashSet((Object[])new PKIXRevocationChecker.Option[]{PKIXRevocationChecker.Option.NO_FALLBACK, PKIXRevocationChecker.Option.PREFER_CRLS});
        if (!validationChecks.contains((Object)ValidationCheck.REVOCATION_LISTS)) {
            options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
        }
        CertPathValidator validator = CertPathValidator.getInstance("PKIX", "SUN");
        this.checker = (PKIXRevocationChecker)validator.getRevocationChecker();
        this.checker.setOptions(options);
        this.initRevocationChecker();
    }

    private void initRevocationChecker() throws Exception {
        Class<?> pkixClass = Class.forName("sun.security.provider.certpath.PKIX");
        Class<?> validatorParamsClass = Class.forName("sun.security.provider.certpath.PKIX$ValidatorParams");
        Class<?> revocationCheckerClass = Class.forName("sun.security.provider.certpath.RevocationChecker");
        Method checkParams = pkixClass.getDeclaredMethod("checkParams", CertPath.class, CertPathParameters.class);
        checkParams.setAccessible(true);
        Object validatorParams = checkParams.invoke(null, this.certPath, this.parameters);
        Method init = revocationCheckerClass.getDeclaredMethod("init", TrustAnchor.class, validatorParamsClass);
        init.setAccessible(true);
        init.invoke((Object)this.checker, this.trustAnchor, validatorParams);
    }

    @Override
    public List<CertPathValidatorException> getSoftFailExceptions() {
        return this.checker.getSoftFailExceptions();
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        this.checker.init(forward);
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return this.checker.isForwardCheckingSupported();
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return this.checker.getSupportedExtensions();
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        try {
            this.initRevocationChecker();
            this.checker.check(cert, unresolvedCritExts);
        }
        catch (CertPathValidatorException e) {
            CertPath certPath = e.getCertPath();
            CertPathValidatorException.Reason reason = e.getReason();
            int failedAtIndex = e.getIndex();
            if (failedAtIndex < 0) {
                throw e;
            }
            X509Certificate failed = (X509Certificate)certPath.getCertificates().get(failedAtIndex);
            if (reason == CertPathValidatorException.BasicReason.REVOKED) {
                if (this.validationChecks.contains((Object)ValidationCheck.REVOCATION)) {
                    throw e;
                }
                LOGGER.warn("check suppressed: certificate failed revocation check: {}", (Object)failed.getSubjectX500Principal().getName());
            }
            if (reason == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                assert (!this.getOptions().contains((Object)PKIXRevocationChecker.Option.SOFT_FAIL));
                assert (this.validationChecks.contains((Object)ValidationCheck.REVOCATION_LISTS));
                throw e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new CertPathValidatorException("revocation checker initialization failed", e);
        }
    }
}

