/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.encoding.encoder.DeltaBinaryEncoder;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.IntRLBE;
import org.apache.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.tsfile.encoding.encoder.LongRLBE;
import org.apache.tsfile.encoding.encoder.LongRleEncoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class FloatEncoder
extends Encoder {
    private final Encoder encoder;
    private int maxPointNumber;
    private double maxPointValue;
    private boolean isMaxPointNumberSaved;
    private final List<Boolean> underflowFlags;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FloatEncoder(TSEncoding encodingType, TSDataType dataType, int maxPointNumber) {
        super(encodingType);
        this.maxPointNumber = maxPointNumber;
        this.calculateMaxPointNum();
        this.isMaxPointNumberSaved = false;
        this.underflowFlags = new ArrayList<Boolean>();
        if (encodingType == TSEncoding.RLE) {
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new IntRleEncoder();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", new Object[]{dataType}));
                this.encoder = new LongRleEncoder();
            }
            return;
        } else if (encodingType == TSEncoding.TS_2DIFF) {
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new DeltaBinaryEncoder.IntDeltaEncoder();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", new Object[]{dataType}));
                this.encoder = new DeltaBinaryEncoder.LongDeltaEncoder();
            }
            return;
        } else {
            if (encodingType != TSEncoding.RLBE) throw new TsFileEncodingException(String.format("%s encoding is not supported by FloatEncoder", new Object[]{encodingType}));
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new IntRLBE();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", new Object[]{dataType}));
                this.encoder = new LongRLBE();
            }
        }
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        this.saveMaxPointNumber(out);
        int valueInt = this.convertFloatToInt(value);
        this.encoder.encode(valueInt, out);
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        this.saveMaxPointNumber(out);
        long valueLong = this.convertDoubleToLong(value);
        this.encoder.encode(valueLong, out);
    }

    private void calculateMaxPointNum() {
        if (this.maxPointNumber <= 0) {
            this.maxPointNumber = 0;
            this.maxPointValue = 1.0;
        } else {
            this.maxPointValue = Math.pow(10.0, this.maxPointNumber);
        }
    }

    private int convertFloatToInt(float value) {
        if ((double)value * this.maxPointValue > 2.147483647E9 || (double)value * this.maxPointValue < -2.147483648E9) {
            if (value > 2.1474836E9f || value < -2.1474836E9f) {
                this.underflowFlags.add(null);
                return Float.floatToIntBits(value);
            }
            this.underflowFlags.add(false);
            return Math.round(value);
        }
        if (Float.isNaN(value)) {
            this.underflowFlags.add(null);
            return Float.floatToIntBits(value);
        }
        this.underflowFlags.add(true);
        return (int)Math.round((double)value * this.maxPointValue);
    }

    private long convertDoubleToLong(double value) {
        if (value * this.maxPointValue > 9.223372036854776E18 || value * this.maxPointValue < -9.223372036854776E18) {
            if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
                this.underflowFlags.add(null);
                return Double.doubleToLongBits(value);
            }
            this.underflowFlags.add(false);
            return Math.round(value);
        }
        if (Double.isNaN(value)) {
            this.underflowFlags.add(null);
            return Double.doubleToLongBits(value);
        }
        this.underflowFlags.add(true);
        return Math.round(value * this.maxPointValue);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        this.encoder.flush(out);
        if (this.hasOverflow().booleanValue()) {
            byte[] ba = out.toByteArray();
            out.reset();
            BitMap bitMapOfValueItselfOverflowInfo = null;
            BitMap bitMapOfUnderflowInfo = new BitMap(this.underflowFlags.size());
            for (int i = 0; i < this.underflowFlags.size(); ++i) {
                if (this.underflowFlags.get(i) == null) {
                    if (bitMapOfValueItselfOverflowInfo == null) {
                        bitMapOfValueItselfOverflowInfo = new BitMap(this.underflowFlags.size());
                    }
                    bitMapOfValueItselfOverflowInfo.mark(i);
                    continue;
                }
                if (!this.underflowFlags.get(i).booleanValue()) continue;
                bitMapOfUnderflowInfo.mark(i);
            }
            if (bitMapOfValueItselfOverflowInfo != null) {
                ReadWriteForEncodingUtils.writeUnsignedVarInt(0x7FFFFFFE, out);
            } else {
                ReadWriteForEncodingUtils.writeUnsignedVarInt(Integer.MAX_VALUE, out);
            }
            ReadWriteForEncodingUtils.writeUnsignedVarInt(this.underflowFlags.size(), out);
            out.write(bitMapOfUnderflowInfo.getByteArray());
            if (bitMapOfValueItselfOverflowInfo != null) {
                out.write(bitMapOfValueItselfOverflowInfo.getByteArray());
            }
            out.write(ba);
        }
        this.reset();
    }

    private void reset() {
        this.isMaxPointNumberSaved = false;
        this.underflowFlags.clear();
    }

    private Boolean hasOverflow() {
        for (Boolean flag : this.underflowFlags) {
            if (flag != null && flag.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void saveMaxPointNumber(ByteArrayOutputStream out) {
        if (!this.isMaxPointNumberSaved) {
            ReadWriteForEncodingUtils.writeUnsignedVarInt(this.maxPointNumber, out);
            this.isMaxPointNumberSaved = true;
        }
    }

    @Override
    public int getOneItemMaxSize() {
        return this.encoder.getOneItemMaxSize();
    }

    @Override
    public long getMaxByteSize() {
        return this.encoder.getMaxByteSize();
    }
}

