/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DataPartitionTable {
    private final Map<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap;

    public DataPartitionTable() {
        this.dataPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, SeriesPartitionTable>();
    }

    public DataPartitionTable(Map<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap) {
        this.dataPartitionMap = dataPartitionMap;
    }

    public Map<TSeriesPartitionSlot, SeriesPartitionTable> getDataPartitionMap() {
        return this.dataPartitionMap;
    }

    public boolean getDataPartition(Map<TSeriesPartitionSlot, TTimeSlotList> partitionSlots, DataPartitionTable dataPartitionTable) {
        AtomicBoolean result = new AtomicBoolean(true);
        if (partitionSlots.isEmpty()) {
            dataPartitionTable.getDataPartitionMap().putAll(this.dataPartitionMap);
        } else {
            partitionSlots.forEach((seriesPartitionSlot, timePartitionSlotList) -> {
                if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
                    SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
                    if (!this.dataPartitionMap.get(seriesPartitionSlot).getDataPartition((TTimeSlotList)timePartitionSlotList, seriesPartitionTable)) {
                        result.set(false);
                    }
                    if (!seriesPartitionTable.getSeriesPartitionMap().isEmpty()) {
                        dataPartitionTable.getDataPartitionMap().put((TSeriesPartitionSlot)seriesPartitionSlot, seriesPartitionTable);
                    }
                } else {
                    result.set(false);
                }
            });
        }
        return result.get();
    }

    public TConsensusGroupId getSuccessorDataPartition(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
        if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
            return this.dataPartitionMap.get(seriesPartitionSlot).getSuccessorDataPartition(timePartitionSlot);
        }
        return null;
    }

    public TConsensusGroupId getPredecessorDataPartition(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
        if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
            return this.dataPartitionMap.get(seriesPartitionSlot).getPredecessorDataPartition(timePartitionSlot);
        }
        return null;
    }

    public Map<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>> createDataPartition(DataPartitionTable assignedDataPartition) {
        ConcurrentHashMap<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>> groupDeltaMap = new ConcurrentHashMap<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>>();
        assignedDataPartition.getDataPartitionMap().forEach((seriesPartitionSlot, seriesPartitionTable) -> this.dataPartitionMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new SeriesPartitionTable()).createDataPartition((SeriesPartitionTable)seriesPartitionTable, (TSeriesPartitionSlot)seriesPartitionSlot, (Map<TConsensusGroupId, Map<TSeriesPartitionSlot, AtomicLong>>)groupDeltaMap));
        return groupDeltaMap;
    }

    public Map<TSeriesPartitionSlot, TTimeSlotList> filterUnassignedDataPartitionSlots(Map<TSeriesPartitionSlot, TTimeSlotList> partitionSlots) {
        ConcurrentHashMap<TSeriesPartitionSlot, TTimeSlotList> result = new ConcurrentHashMap<TSeriesPartitionSlot, TTimeSlotList>();
        partitionSlots.forEach((seriesPartitionSlot, timePartitionSlots) -> result.put((TSeriesPartitionSlot)seriesPartitionSlot, new TTimeSlotList(this.dataPartitionMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new SeriesPartitionTable()).filterUnassignedDataPartitionSlots(timePartitionSlots.getTimePartitionSlots()), false, false)));
        return result;
    }

    public List<TConsensusGroupId> getRegionId(TSeriesPartitionSlot seriesSlotId, TTimePartitionSlot startTimeSlotId, TTimePartitionSlot endTimeSlotId) {
        if (seriesSlotId.getSlotId() == -1) {
            ArrayList<TConsensusGroupId> regionIds = new ArrayList<TConsensusGroupId>();
            this.dataPartitionMap.forEach((seriesPartitionSlot, seriesPartitionTable) -> regionIds.addAll(seriesPartitionTable.getRegionId(startTimeSlotId, endTimeSlotId)));
            return regionIds;
        }
        if (!this.dataPartitionMap.containsKey(seriesSlotId)) {
            return new ArrayList<TConsensusGroupId>();
        }
        SeriesPartitionTable seriesPartitionTable2 = this.dataPartitionMap.get(seriesSlotId);
        return seriesPartitionTable2.getRegionId(startTimeSlotId, endTimeSlotId);
    }

    public List<TTimePartitionSlot> getTimeSlotList(TSeriesPartitionSlot seriesSlotId, TConsensusGroupId regionId, long startTime, long endTime) {
        if (seriesSlotId.getSlotId() == -1) {
            ArrayList<TTimePartitionSlot> timePartitionSlots = new ArrayList<TTimePartitionSlot>();
            this.dataPartitionMap.forEach((seriesPartitionSlot, seriesPartitionTable) -> timePartitionSlots.addAll(seriesPartitionTable.getTimeSlotList(regionId, startTime, endTime)));
            return timePartitionSlots;
        }
        if (!this.dataPartitionMap.containsKey(seriesSlotId)) {
            return new ArrayList<TTimePartitionSlot>();
        }
        SeriesPartitionTable seriesPartitionTable2 = this.dataPartitionMap.get(seriesSlotId);
        return seriesPartitionTable2.getTimeSlotList(regionId, startTime, endTime);
    }

    public long getTimeSlotCount() {
        AtomicLong sum = new AtomicLong();
        this.dataPartitionMap.forEach((seriesPartitionSlot, seriesPartitionTable) -> sum.addAndGet(seriesPartitionTable.getSeriesPartitionMap().size()));
        return sum.get();
    }

    public List<TSeriesPartitionSlot> getSeriesSlotList() {
        return this.dataPartitionMap.keySet().stream().sorted(Comparator.comparing(TSeriesPartitionSlot::getSlotId)).collect(Collectors.toList());
    }

    public Map<TSeriesPartitionSlot, TConsensusGroupId> getLastDataAllotTable() {
        HashMap<TSeriesPartitionSlot, TConsensusGroupId> result = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
        this.dataPartitionMap.forEach((seriesPartitionSlot, seriesPartitionTable) -> result.put((TSeriesPartitionSlot)seriesPartitionSlot, seriesPartitionTable.getLastConsensusGroupId()));
        return result;
    }

    public Set<TTimePartitionSlot> autoCleanPartitionTable(long TTL, TTimePartitionSlot currentTimeSlot) {
        HashSet<TTimePartitionSlot> removedTimePartitionSlots = new HashSet<TTimePartitionSlot>();
        this.dataPartitionMap.forEach((seriesPartitionSlot, seriesPartitionTable) -> removedTimePartitionSlots.addAll(seriesPartitionTable.autoCleanPartitionTable(TTL, currentTimeSlot)));
        return removedTimePartitionSlots;
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.dataPartitionMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TSeriesPartitionSlot, SeriesPartitionTable> seriesPartitionTableEntry : this.dataPartitionMap.entrySet()) {
            seriesPartitionTableEntry.getKey().write(protocol);
            seriesPartitionTableEntry.getValue().serialize(outputStream, protocol);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot(buffer);
            SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
            seriesPartitionTable.deserialize(buffer);
            this.dataPartitionMap.put(seriesPartitionSlot, seriesPartitionTable);
        }
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot();
            seriesPartitionSlot.read(protocol);
            SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
            seriesPartitionTable.deserialize(inputStream, protocol);
            this.dataPartitionMap.put(seriesPartitionSlot, seriesPartitionTable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPartitionTable that = (DataPartitionTable)o;
        return this.dataPartitionMap.equals(that.dataPartitionMap);
    }

    public int hashCode() {
        return Objects.hash(this.dataPartitionMap);
    }
}

