/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table.column;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AttributeColumnSchema
extends TsTableColumnSchema {
    public AttributeColumnSchema(String columnName, TSDataType dataType) {
        super(columnName, dataType);
    }

    public AttributeColumnSchema(String columnName, TSDataType dataType, Map<String, String> props) {
        super(columnName, dataType, props);
    }

    @Override
    public TsTableColumnCategory getColumnCategory() {
        return TsTableColumnCategory.ATTRIBUTE;
    }

    static AttributeColumnSchema deserialize(InputStream stream) throws IOException {
        String columnName = ReadWriteIOUtils.readString((InputStream)stream);
        TSDataType dataType = ReadWriteIOUtils.readDataType((InputStream)stream);
        Map props = ReadWriteIOUtils.readMap((InputStream)stream);
        return new AttributeColumnSchema(columnName, dataType, props);
    }

    static AttributeColumnSchema deserialize(ByteBuffer buffer) {
        String columnName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        TSDataType dataType = ReadWriteIOUtils.readDataType((ByteBuffer)buffer);
        Map props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        return new AttributeColumnSchema(columnName, dataType, props);
    }
}

