/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiver;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferTabletBinaryReqV2
extends PipeTransferTabletBinaryReq {
    private transient String dataBaseName;

    protected PipeTransferTabletBinaryReqV2() {
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    @Override
    public InsertBaseStatement constructStatement() {
        List<InsertRowStatement> rowStatements;
        InsertNode insertNode = this.parseByteBuffer();
        if (!(insertNode instanceof InsertRowNode || insertNode instanceof InsertTabletNode || insertNode instanceof InsertRowsNode)) {
            throw new UnsupportedOperationException(String.format("Unknown InsertNode type %s when constructing statement from insert node.", insertNode));
        }
        InsertBaseStatement statement = (InsertBaseStatement)IoTDBDataNodeReceiver.PLAN_TO_STATEMENT_VISITOR.process(insertNode, null);
        if (Objects.isNull(this.dataBaseName)) {
            return statement;
        }
        statement.setWriteToTable(true);
        if (statement instanceof InsertRowsStatement && (rowStatements = ((InsertRowsStatement)statement).getInsertRowStatementList()) != null && !rowStatements.isEmpty()) {
            for (InsertRowStatement insertRowStatement : rowStatements) {
                insertRowStatement.setWriteToTable(true);
                insertRowStatement.setDatabaseName(this.dataBaseName);
            }
        }
        statement.setDatabaseName(this.dataBaseName);
        return statement;
    }

    public static PipeTransferTabletBinaryReqV2 toTPipeTransferBinaryReq(ByteBuffer byteBuffer, String dataBaseName) {
        PipeTransferTabletBinaryReqV2 req = new PipeTransferTabletBinaryReqV2();
        req.byteBuffer = byteBuffer;
        req.dataBaseName = dataBaseName;
        req.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_BINARY_V2.getType();
        return req;
    }

    public static PipeTransferTabletBinaryReqV2 toTPipeTransferReq(ByteBuffer byteBuffer, String dataBaseName) throws IOException {
        PipeTransferTabletBinaryReqV2 req = new PipeTransferTabletBinaryReqV2();
        req.byteBuffer = byteBuffer;
        req.dataBaseName = dataBaseName;
        req.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_TABLET_BINARY_V2.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)byteBuffer.limit(), (OutputStream)outputStream);
            outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
            ReadWriteIOUtils.write((String)dataBaseName, (OutputStream)outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeTransferTabletBinaryReqV2 fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletBinaryReqV2 binaryReq = new PipeTransferTabletBinaryReqV2();
        int length = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        byte[] body = new byte[length];
        transferReq.body.get(body);
        binaryReq.byteBuffer = ByteBuffer.wrap(body);
        binaryReq.dataBaseName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        binaryReq.version = transferReq.version;
        binaryReq.type = transferReq.type;
        binaryReq.body = transferReq.body;
        return binaryReq;
    }

    public static byte[] toTPipeTransferBytes(ByteBuffer byteBuffer, String dataBaseName) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBSinkRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_BINARY_V2.getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)byteBuffer.limit(), (OutputStream)outputStream);
                outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
                ReadWriteIOUtils.write((String)dataBaseName, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipeTransferTabletBinaryReqV2 that = (PipeTransferTabletBinaryReqV2)((Object)o);
        return Objects.equals(this.dataBaseName, that.dataBaseName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataBaseName);
    }
}

