/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime;

import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeRealtimeDataRegionHeartbeatSource
extends PipeRealtimeDataRegionSource {
    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent = null;
            if (realtimeEvent.getEvent() instanceof PipeHeartbeatEvent) {
                suppliedEvent = this.supplyHeartbeat(realtimeEvent);
            } else if (realtimeEvent.getEvent() instanceof ProgressReportEvent) {
                suppliedEvent = this.supplyDirectly(realtimeEvent);
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionHeartbeatSource.class.getName(), false);
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        if (event.getEvent() instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
        } else {
            event.decreaseReferenceCount(PipeRealtimeDataRegionHeartbeatSource.class.getName(), false);
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return false;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return false;
    }

    @Override
    public String toString() {
        return "PipeRealtimeDataRegionHeartbeatExtractor{dataRegionId='" + this.dataRegionId + '\'' + '}';
    }
}

