/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationWindowParameter;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;

public abstract class AbstractVariationWindow
implements IWindow {
    private final double delta;
    private final int controlColumnIndex;
    private final boolean outputEndTime;
    private final boolean ignoreNull;
    protected long startTime;
    protected long endTime;
    protected boolean initializedHeadValue;
    protected boolean valueIsNull = false;

    protected AbstractVariationWindow(VariationWindowParameter variationWindowParameter) {
        this.controlColumnIndex = variationWindowParameter.getControlColumnIndex();
        this.ignoreNull = variationWindowParameter.isIgnoringNull();
        this.outputEndTime = variationWindowParameter.isNeedOutputEndTime();
        this.delta = variationWindowParameter.getDelta();
    }

    @Override
    public Column getControlColumn(TsBlock tsBlock) {
        return tsBlock.getColumn(this.controlColumnIndex);
    }

    @Override
    public boolean contains(Column column) {
        return false;
    }

    public abstract void updatePreviousValue();

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setInitializedHeadValue(boolean initializedHeadValue) {
        this.initializedHeadValue = initializedHeadValue;
    }

    public boolean ignoreNull() {
        return this.ignoreNull;
    }

    public boolean valueIsNull() {
        return this.valueIsNull;
    }

    public boolean isOutputEndTime() {
        return this.outputEndTime;
    }

    public double getDelta() {
        return this.delta;
    }
}

