/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionInfo;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowSubscriptions;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.ShowSubscriptionsStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowSubscriptionsTask
implements IConfigTask {
    private final ShowSubscriptionsStatement showSubscriptionsStatement;

    public ShowSubscriptionsTask(ShowSubscriptionsStatement showSubscriptionsStatement) {
        this.showSubscriptionsStatement = showSubscriptionsStatement;
    }

    public ShowSubscriptionsTask(ShowSubscriptions showSubscriptions) {
        this.showSubscriptionsStatement = new ShowSubscriptionsStatement();
        this.showSubscriptionsStatement.setTopicName(showSubscriptions.getTopicName());
        this.showSubscriptionsStatement.setTableModel(true);
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showSubscriptions(this.showSubscriptionsStatement);
    }

    public static void buildTSBlock(List<TShowSubscriptionInfo> subscriptionInfoList, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(ColumnHeaderConstant.showSubscriptionColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList()));
        for (TShowSubscriptionInfo tSubscriptionInfo : subscriptionInfoList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            StringBuilder subscriptionId = new StringBuilder(tSubscriptionInfo.getTopicName() + "_" + tSubscriptionInfo.getConsumerGroupId());
            if (tSubscriptionInfo.getCreationTime() != 0L) {
                subscriptionId.append("_").append(tSubscriptionInfo.getCreationTime());
            }
            builder.getColumnBuilder(0).writeBinary(new Binary(subscriptionId.toString(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(tSubscriptionInfo.getTopicName(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(2).writeBinary(new Binary(tSubscriptionInfo.getConsumerGroupId(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(3).writeBinary(new Binary(tSubscriptionInfo.getConsumerIds().toString(), TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), DatasetHeaderFactory.getShowSubscriptionHeader()));
    }
}

