/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.DataOrganizationSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingTranslator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlanBuilder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ScopeAware;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SubqueryPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TranslationMap;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.GapFillStartAndEndTimeExtractVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LinearFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PreviousFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ValueFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.WindowNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FrameBound;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.MeasureDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QueryBody;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SortItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.VariableDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowFrame;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.relational.utils.NodeUtils;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.Type;

public class QueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final MPPQueryContext queryContext;
    private final QueryId queryIdAllocator;
    private final SessionInfo session;
    private final SubqueryPlanner subqueryPlanner;
    private final Optional<TranslationMap> outerContext;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    public QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, MPPQueryContext queryContext, Optional<TranslationMap> outerContext, SessionInfo session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(queryContext, "queryContext is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.queryContext = queryContext;
        this.queryIdAllocator = queryContext.getQueryId();
        this.session = session;
        this.outerContext = outerContext;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, queryContext, outerContext, session, recursiveSubqueries);
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public RelationPlan plan(Query query) {
        PlanBuilder builder = this.planQueryBody(query.getQueryBody());
        builder = this.fill(builder, query.getFill());
        List<Analysis.SelectExpression> selectExpressions = this.analysis.getSelectExpressions(query);
        List outputs = (List)selectExpressions.stream().map(Analysis.SelectExpression::getExpression).collect(ImmutableList.toImmutableList());
        List<Expression> orderBy = this.analysis.getOrderByExpressions(query);
        if (!orderBy.isEmpty()) {
            builder = builder.appendProjections(Iterables.concat(orderBy, (Iterable)outputs), this.symbolAllocator, this.queryContext);
        }
        Optional<OrderingScheme> orderingScheme = this.orderingScheme(builder, query.getOrderBy(), this.analysis.getOrderByExpressions(query));
        builder = this.sort(builder, orderingScheme);
        builder = this.offset(builder, query.getOffset());
        builder = this.limit(builder, query.getLimit(), orderingScheme);
        builder = builder.appendProjections(outputs, this.symbolAllocator, this.queryContext);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope(query), QueryPlanner.computeOutputs(builder, outputs), this.outerContext);
    }

    public RelationPlan plan(QuerySpecification node) {
        List<Expression> orderBy;
        ArrayList<Symbol> newFields;
        PlanBuilder builder = this.planFrom(node);
        builder = this.filter(builder, this.analysis.getWhere(node), node);
        Expression wherePredicate = null;
        if (builder.getRoot() instanceof FilterNode) {
            wherePredicate = ((FilterNode)builder.getRoot()).getPredicate();
        }
        Symbol timeColumnForGapFill = null;
        FunctionCall gapFillColumn = this.analysis.getGapFill(node);
        if (gapFillColumn != null) {
            timeColumnForGapFill = builder.translate((Expression)gapFillColumn.getChildren().get(2));
        }
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node), node);
        builder = this.planWindowFunctions(node, builder, (List<FunctionCall>)ImmutableList.copyOf(this.analysis.getWindowFunctions(node)));
        if (gapFillColumn != null) {
            if (wherePredicate == null) {
                throw new SemanticException("could not infer startTime or endTime from WHERE clause");
            }
            builder = this.gapFill(builder, timeColumnForGapFill, gapFillColumn, this.analysis.getGapFillGroupingKeys(node), wherePredicate);
        }
        List<Analysis.SelectExpression> selectExpressions = this.analysis.getSelectExpressions(node);
        List expressions = (List)selectExpressions.stream().map(Analysis.SelectExpression::getExpression).collect(ImmutableList.toImmutableList());
        builder = this.subqueryPlanner.handleSubqueries(builder, expressions, this.analysis.getSubqueries(node));
        if (QueryPlanner.hasExpressionsToUnfold(selectExpressions)) {
            builder = builder.appendProjections(expressions, this.symbolAllocator, this.queryContext);
        }
        List<Expression> outputs = QueryPlanner.outputExpressions(selectExpressions);
        if (node.getFill().isPresent()) {
            builder = builder.appendProjections(outputs, this.symbolAllocator, this.queryContext);
            newFields = new ArrayList<Symbol>(builder.getTranslations().getFieldSymbolsList());
            outputs.stream().map(builder::translate).forEach(newFields::add);
            builder = builder.withScope(this.analysis.getScope(node.getFill().get()), newFields);
            builder = this.fill(builder, node.getFill());
        }
        if (node.getOrderBy().isPresent()) {
            if (this.analysis.isAggregation(node)) {
                List<Expression> orderByAggregates = this.analysis.getOrderByAggregates(node.getOrderBy().orElse(null));
                builder = builder.appendProjections(orderByAggregates, this.symbolAllocator, this.queryContext);
            }
            builder = builder.appendProjections(outputs, this.symbolAllocator, this.queryContext);
            newFields = new ArrayList<Symbol>(builder.getTranslations().getFieldSymbolsList());
            outputs.stream().map(builder::translate).forEach(newFields::add);
            builder = builder.withScope(this.analysis.getScope(node.getOrderBy().orElse(null)), newFields);
            builder = this.planWindowFunctions(node, builder, (List<FunctionCall>)ImmutableList.copyOf(this.analysis.getOrderByWindowFunctions(node.getOrderBy().get())));
            this.analysis.setSortNode(true);
        }
        if (!(orderBy = this.analysis.getOrderByExpressions(node)).isEmpty() || node.getSelect().isDistinct()) {
            builder = builder.appendProjections(Iterables.concat(orderBy, outputs), this.symbolAllocator, this.queryContext);
        }
        builder = this.distinct(builder, node, outputs);
        Optional<OrderingScheme> orderingScheme = this.orderingScheme(builder, node.getOrderBy(), this.analysis.getOrderByExpressions(node));
        builder = this.sort(builder, orderingScheme);
        builder = this.offset(builder, node.getOffset());
        builder = this.limit(builder, node.getLimit(), orderingScheme);
        builder = builder.appendProjections(outputs, this.symbolAllocator, this.queryContext);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope(node), QueryPlanner.computeOutputs(builder, outputs), this.outerContext);
    }

    private PlanBuilder planWindowFunctions(Node node, PlanBuilder subPlan, List<FunctionCall> windowFunctions) {
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        Map<Analysis.ResolvedWindow, List<FunctionCall>> functions = this.scopeAwareDistinct(subPlan, windowFunctions).stream().collect(Collectors.groupingBy(this.analysis::getWindow));
        for (Map.Entry<Analysis.ResolvedWindow, List<FunctionCall>> entry : functions.entrySet()) {
            Optional<Expression> endValue;
            Optional<Expression> startValue;
            Analysis.ResolvedWindow window = entry.getKey();
            List<FunctionCall> functionCalls = entry.getValue();
            ImmutableList.Builder inputsBuilder = ImmutableList.builder().addAll(window.getPartitionBy()).addAll(NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).stream().map(SortItem::getSortKey).iterator());
            if (window.getFrame().isPresent()) {
                WindowFrame frame = window.getFrame().get();
                frame.getStart().getValue().ifPresent(arg_0 -> ((ImmutableList.Builder)inputsBuilder).add(arg_0));
                if (frame.getEnd().isPresent()) {
                    frame.getEnd().get().getValue().ifPresent(arg_0 -> ((ImmutableList.Builder)inputsBuilder).add(arg_0));
                }
            }
            for (FunctionCall windowFunction : functionCalls) {
                inputsBuilder.addAll(new ArrayList<Expression>(windowFunction.getArguments()));
            }
            ImmutableList inputs = inputsBuilder.build();
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, (Collection<Expression>)inputs, this.analysis.getSubqueries(node));
            subPlan = subPlan.appendProjections(inputs, this.symbolAllocator, this.queryContext);
            PlanAndMappings coercions = QueryPlanner.coerce(subPlan, (List<Expression>)inputs, this.analysis, this.queryIdAllocator, this.symbolAllocator);
            subPlan = coercions.getSubPlan();
            Optional<Symbol> frameStart = Optional.empty();
            Optional<Symbol> frameEnd = Optional.empty();
            Optional<Symbol> sortKeyCoercedForFrameStartComparison = Optional.empty();
            Optional<Symbol> sortKeyCoercedForFrameEndComparison = Optional.empty();
            if (window.getFrame().isPresent() && window.getFrame().get().getType() == WindowFrame.Type.RANGE) {
                startValue = window.getFrame().get().getStart().getValue();
                endValue = window.getFrame().get().getEnd().flatMap(FrameBound::getValue);
                HashMap<Type, Symbol> sortKeyCoercions = new HashMap<Type, Symbol>();
                FrameBoundPlanAndSymbols plan = this.planFrameBound(subPlan, coercions, startValue, window, sortKeyCoercions);
                subPlan = plan.getSubPlan();
                frameStart = plan.getFrameBoundSymbol();
                sortKeyCoercedForFrameStartComparison = plan.getSortKeyCoercedForFrameBoundComparison();
                plan = this.planFrameBound(subPlan, coercions, endValue, window, sortKeyCoercions);
                subPlan = plan.getSubPlan();
                frameEnd = plan.getFrameBoundSymbol();
                sortKeyCoercedForFrameEndComparison = plan.getSortKeyCoercedForFrameBoundComparison();
            } else if (window.getFrame().isPresent() && (window.getFrame().get().getType() == WindowFrame.Type.ROWS || window.getFrame().get().getType() == WindowFrame.Type.GROUPS)) {
                startValue = window.getFrame().get().getStart().getValue();
                endValue = window.getFrame().get().getEnd().flatMap(FrameBound::getValue);
                FrameOffsetPlanAndSymbol plan = this.planFrameOffset(subPlan, startValue, coercions);
                subPlan = plan.getSubPlan();
                frameStart = plan.getFrameOffsetSymbol();
                plan = this.planFrameOffset(subPlan, endValue, coercions);
                subPlan = plan.getSubPlan();
                frameEnd = plan.getFrameOffsetSymbol();
            } else if (window.getFrame().isPresent()) {
                throw new IllegalArgumentException("unexpected window frame type: " + (Object)((Object)window.getFrame().get().getType()));
            }
            subPlan = this.planWindow(subPlan, functionCalls, window, coercions, frameStart, sortKeyCoercedForFrameStartComparison, frameEnd, sortKeyCoercedForFrameEndComparison);
        }
        return subPlan;
    }

    private PlanBuilder planWindow(PlanBuilder subPlan, List<FunctionCall> windowFunctions, Analysis.ResolvedWindow window, PlanAndMappings coercions, Optional<Symbol> frameStartSymbol, Optional<Symbol> sortKeyCoercedForFrameStartComparison, Optional<Symbol> frameEndSymbol, Optional<Symbol> sortKeyCoercedForFrameEndComparison) {
        WindowFrame.Type frameType = WindowFrame.Type.RANGE;
        FrameBound.Type frameStartType = FrameBound.Type.UNBOUNDED_PRECEDING;
        FrameBound.Type frameEndType = FrameBound.Type.CURRENT_ROW;
        Optional<Expression> frameStartExpression = Optional.empty();
        Optional<Expression> frameEndExpression = Optional.empty();
        if (window.getFrame().isPresent()) {
            WindowFrame frame = window.getFrame().get();
            frameType = frame.getType();
            frameStartType = frame.getStart().getType();
            frameStartExpression = frame.getStart().getValue();
            if (frame.getEnd().isPresent()) {
                frameEndType = frame.getEnd().get().getType();
                frameEndExpression = frame.getEnd().get().getValue();
            }
        }
        DataOrganizationSpecification specification = QueryPlanner.planWindowSpecification(window.getPartitionBy(), window.getOrderBy(), coercions::get);
        WindowNode.Frame frame = new WindowNode.Frame(frameType, frameStartType, frameStartSymbol, sortKeyCoercedForFrameStartComparison, frameEndType, frameEndSymbol, sortKeyCoercedForFrameEndComparison, frameStartExpression, frameEndExpression);
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        for (FunctionCall windowFunction : windowFunctions) {
            Symbol newSymbol = this.symbolAllocator.newSymbol(windowFunction, this.analysis.getType(windowFunction));
            FunctionCall.NullTreatment nullTreatment = windowFunction.getNullTreatment().orElse(FunctionCall.NullTreatment.RESPECT);
            WindowNode.Function function = new WindowNode.Function(this.analysis.getResolvedFunction(windowFunction), (List)windowFunction.getArguments().stream().map(argument -> coercions.get((Expression)argument).toSymbolReference()).collect(ImmutableList.toImmutableList()), frame, nullTreatment == FunctionCall.NullTreatment.IGNORE);
            functions.put((Object)newSymbol, (Object)function);
            mappings.put(ScopeAware.scopeAwareKey(windowFunction, this.analysis, subPlan.getScope()), (Object)newSymbol);
        }
        ArrayList<Symbol> sortSymbols = new ArrayList<Symbol>();
        HashMap<Symbol, SortOrder> sortOrderings = new HashMap<Symbol, SortOrder>();
        for (Symbol symbol : specification.getPartitionBy()) {
            sortSymbols.add(symbol);
            sortOrderings.put(symbol, SortOrder.ASC_NULLS_LAST);
        }
        int sortKeyOffset = sortSymbols.size();
        specification.getOrderingScheme().ifPresent(orderingScheme -> {
            for (Symbol symbol : orderingScheme.getOrderBy()) {
                if (sortOrderings.containsKey(symbol)) continue;
                sortSymbols.add(symbol);
                sortOrderings.put(symbol, orderingScheme.getOrdering(symbol));
            }
        });
        PlanBuilder planBuilder = null;
        if (!sortSymbols.isEmpty()) {
            GroupNode groupNode = new GroupNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), new OrderingScheme(sortSymbols, sortOrderings), sortKeyOffset);
            planBuilder = new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)mappings.buildOrThrow()), groupNode);
        }
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)mappings.buildOrThrow()), new WindowNode(this.queryIdAllocator.genPlanNodeId(), planBuilder != null ? planBuilder.getRoot() : subPlan.getRoot(), specification, (Map<Symbol, WindowNode.Function>)functions.buildOrThrow(), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0));
    }

    /*
     * WARNING - void declaration
     */
    public static DataOrganizationSpecification planWindowSpecification(List<Expression> partitionBy, Optional<OrderBy> orderBy, Function<Expression, Symbol> expressionRewrite) {
        void var5_9;
        ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
        for (Expression expression : partitionBy) {
            partitionBySymbols.add((Object)expressionRewrite.apply(expression));
        }
        LinkedHashMap<Symbol, SortOrder> orderings = new LinkedHashMap<Symbol, SortOrder>();
        for (SortItem item : NodeUtils.getSortItemsFromOrderBy(orderBy)) {
            Symbol symbol = expressionRewrite.apply(item.getSortKey());
            orderings.putIfAbsent(symbol, OrderingTranslator.sortItemToSortOrder(item));
        }
        Optional optional = Optional.empty();
        if (!orderings.isEmpty()) {
            Optional<OrderingScheme> optional2 = Optional.of(new OrderingScheme((List<Symbol>)ImmutableList.copyOf(orderings.keySet()), orderings));
        }
        return new DataOrganizationSpecification((List<Symbol>)partitionBySymbols.build(), (Optional<OrderingScheme>)var5_9);
    }

    private FrameBoundPlanAndSymbols planFrameBound(PlanBuilder subPlan, PlanAndMappings coercions, Optional<Expression> frameOffset, Analysis.ResolvedWindow window, Map<Type, Symbol> sortKeyCoercions) {
        if (!frameOffset.isPresent()) {
            return new FrameBoundPlanAndSymbols(subPlan, Optional.empty(), Optional.empty());
        }
        Symbol offsetSymbol = coercions.get(frameOffset.get());
        Expression zeroOffset = QueryPlanner.zeroOfType(this.symbolAllocator.getTypes().getTableModelType(offsetSymbol));
        IfExpression predicate = new IfExpression(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, offsetSymbol.toSymbolReference(), zeroOffset), BooleanLiteral.TRUE_LITERAL, new Cast(new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)));
        subPlan = subPlan.withNewRoot(new FilterNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), predicate));
        Expression sortKey = ((SortItem)Iterables.getOnlyElement(window.getOrderBy().get().getSortItems())).getSortKey();
        Symbol sortKeyCoercedForFrameBoundCalculation = coercions.get(sortKey);
        Optional<Type> coercion = frameOffset.map(this.analysis::getSortKeyCoercionForFrameBoundCalculation);
        if (coercion.isPresent()) {
            Type expectedType = coercion.get();
            Symbol alreadyCoerced = sortKeyCoercions.get(expectedType);
            if (alreadyCoerced != null) {
                sortKeyCoercedForFrameBoundCalculation = alreadyCoerced;
            } else {
                Cast cast = new Cast(coercions.get(sortKey).toSymbolReference(), TypeSignatureTranslator.toSqlType(expectedType), false, this.analysis.getType(sortKey).equals(expectedType));
                sortKeyCoercedForFrameBoundCalculation = this.symbolAllocator.newSymbol(cast, expectedType);
                sortKeyCoercions.put(expectedType, sortKeyCoercedForFrameBoundCalculation);
                subPlan = subPlan.withNewRoot(new ProjectNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(sortKeyCoercedForFrameBoundCalculation, cast).build()));
            }
        }
        Optional<Symbol> sortKeyCoercedForFrameBoundComparison = Optional.of(coercions.get(sortKey));
        coercion = frameOffset.map(this.analysis::getSortKeyCoercionForFrameBoundComparison);
        if (coercion.isPresent()) {
            Type expectedType = coercion.get();
            Symbol alreadyCoerced = sortKeyCoercions.get(expectedType);
            if (alreadyCoerced != null) {
                sortKeyCoercedForFrameBoundComparison = Optional.of(alreadyCoerced);
            } else {
                Cast cast = new Cast(coercions.get(sortKey).toSymbolReference(), TypeSignatureTranslator.toSqlType(expectedType), false, this.analysis.getType(sortKey).equals(expectedType));
                Symbol castSymbol = this.symbolAllocator.newSymbol(cast, expectedType);
                sortKeyCoercions.put(expectedType, castSymbol);
                subPlan = subPlan.withNewRoot(new ProjectNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(castSymbol, cast).build()));
                sortKeyCoercedForFrameBoundComparison = Optional.of(castSymbol);
            }
        }
        Symbol frameBoundSymbol = coercions.get(frameOffset.get());
        return new FrameBoundPlanAndSymbols(subPlan, Optional.of(frameBoundSymbol), sortKeyCoercedForFrameBoundComparison);
    }

    private FrameOffsetPlanAndSymbol planFrameOffset(PlanBuilder subPlan, Optional<Expression> frameOffset, PlanAndMappings coercions) {
        long frameOffsetValue;
        if (!frameOffset.isPresent()) {
            return new FrameOffsetPlanAndSymbol(subPlan, Optional.empty());
        }
        if (frameOffset.get() instanceof LongLiteral && (frameOffsetValue = ((LongLiteral)frameOffset.get()).getParsedValue()) < 0L) {
            throw new SemanticException("Window frame offset value must not be negative or null");
        }
        Symbol offsetSymbol = frameOffset.map(coercions::get).get();
        Type offsetType = this.symbolAllocator.getTypes().getTableModelType(offsetSymbol);
        Expression zeroOffset = QueryPlanner.zeroOfType(offsetType);
        IfExpression predicate = new IfExpression(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, offsetSymbol.toSymbolReference(), zeroOffset), BooleanLiteral.TRUE_LITERAL, new Cast(new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)));
        subPlan = subPlan.withNewRoot(new FilterNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), predicate));
        return new FrameOffsetPlanAndSymbol(subPlan, Optional.of(offsetSymbol));
    }

    private static Expression zeroOfType(Type type) {
        if (TableMetadataImpl.isNumericType(type)) {
            return new Cast(new LongLiteral("0"), TypeSignatureTranslator.toSqlType(type));
        }
        throw new IllegalArgumentException("unexpected type: " + type);
    }

    private static boolean hasExpressionsToUnfold(List<Analysis.SelectExpression> selectExpressions) {
        return selectExpressions.stream().map(Analysis.SelectExpression::getUnfoldedExpressions).anyMatch(Optional::isPresent);
    }

    private static List<Expression> outputExpressions(List<Analysis.SelectExpression> selectExpressions) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Analysis.SelectExpression selectExpression : selectExpressions) {
            if (selectExpression.getUnfoldedExpressions().isPresent()) {
                result.addAll((Iterable)selectExpression.getUnfoldedExpressions().get());
                continue;
            }
            result.add((Object)selectExpression.getExpression());
        }
        return result.build();
    }

    public PlanNode plan(Delete node) {
        return null;
    }

    private static List<Symbol> computeOutputs(PlanBuilder builder, List<Expression> outputExpressions) {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (Expression expression : outputExpressions) {
            outputSymbols.add((Object)builder.translate(expression));
        }
        return outputSymbols.build();
    }

    private PlanBuilder planQueryBody(QueryBody queryBody) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.queryContext, this.outerContext, this.session, this.recursiveSubqueries).process(queryBody, null);
        return PlanBuilder.newPlanBuilder(relationPlan, this.analysis);
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        if (node.getFrom().isPresent()) {
            RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.queryContext, this.outerContext, this.session, this.recursiveSubqueries).process(node.getFrom().orElse(null), null);
            return PlanBuilder.newPlanBuilder(relationPlan, this.analysis);
        }
        throw new SemanticException("From clause must not be empty");
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate, Node node) {
        if (predicate == null) {
            return subPlan;
        }
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, predicate, this.analysis.getSubqueries(node));
        return subPlan.withNewRoot(new FilterNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), subPlan.rewrite(predicate)));
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        if (!this.analysis.isAggregation(node)) {
            return subPlan;
        }
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).forEach(arg_0 -> ((ImmutableList.Builder)inputBuilder).add(arg_0));
        Analysis.GroupingSetAnalysis groupingSetAnalysis = this.analysis.getGroupingSets(node);
        inputBuilder.addAll(groupingSetAnalysis.getComplexExpressions());
        ImmutableList inputs = inputBuilder.build();
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, (Collection<Expression>)inputs, this.analysis.getSubqueries(node));
        subPlan = subPlan.appendProjections(inputs, this.symbolAllocator, this.queryContext);
        Function<Expression, Expression> rewrite = subPlan.getTranslations()::rewrite;
        GroupingSetsPlan groupingSets = this.planGroupingSets(subPlan, node, groupingSetAnalysis);
        return this.planAggregation(groupingSets.getSubPlan(), groupingSets.getGroupingSets(), groupingSets.getGroupIdSymbol(), this.analysis.getAggregates(node), rewrite);
    }

    /*
     * WARNING - void declaration
     */
    private GroupingSetsPlan planGroupingSets(PlanBuilder subPlan, QuerySpecification node, Analysis.GroupingSetAnalysis groupingSetAnalysis) {
        void var7_11;
        LinkedHashMap<Symbol, Symbol> groupingSetMappings = new LinkedHashMap<Symbol, Symbol>();
        Symbol[] fields = new Symbol[subPlan.getTranslations().getFieldSymbolsList().size()];
        for (FieldId fieldId : groupingSetAnalysis.getAllFields()) {
            Symbol output;
            Symbol input = subPlan.getTranslations().getFieldSymbolsList().get(fieldId.getFieldIndex());
            fields[fieldId.getFieldIndex()] = output = this.symbolAllocator.newSymbol(input, "gid");
            groupingSetMappings.put(output, input);
        }
        LinkedHashMap<ScopeAware<Expression>, Symbol> complexExpressions = new LinkedHashMap<ScopeAware<Expression>, Symbol>();
        for (Expression expression : groupingSetAnalysis.getComplexExpressions()) {
            if (complexExpressions.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, subPlan.getScope()))) continue;
            Symbol input = subPlan.translate(expression);
            Symbol output = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression), "gid");
            complexExpressions.put(ScopeAware.scopeAwareKey(expression, this.analysis, subPlan.getScope()), output);
            groupingSetMappings.put(output, input);
        }
        List<Set<FieldId>> list = QueryPlanner.enumerateGroupingSets(groupingSetAnalysis);
        if (node.getGroupBy().isPresent() && node.getGroupBy().get().isDistinct()) {
            List list2 = (List)list.stream().distinct().collect(ImmutableList.toImmutableList());
        }
        List sets = (List)var7_11.stream().map(set -> (ImmutableList)set.stream().map(FieldId::getFieldIndex).map(index -> fields[index]).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        List groupingSets = (List)sets.stream().map(set -> ImmutableList.builder().addAll((Iterable)set).addAll(complexExpressions.values()).build()).collect(ImmutableList.toImmutableList());
        Optional<Symbol> groupIdSymbol = Optional.empty();
        Preconditions.checkArgument((groupingSets.size() == 1 ? 1 : 0) != 0, (Object)"Only support one groupingSet now");
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(subPlan.getRoot().getOutputSymbols());
        groupingSetMappings.forEach((key, value) -> assignments.put((Symbol)key, value.toSymbolReference()));
        ProjectNode groupId = new ProjectNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), assignments.build());
        subPlan = new PlanBuilder(subPlan.getTranslations().withNewMappings(complexExpressions, Arrays.asList(fields)), groupId);
        return new GroupingSetsPlan(subPlan, (List<Set<FieldId>>)var7_11, groupingSets, groupIdSymbol);
    }

    private PlanBuilder planAggregation(PlanBuilder subPlan, List<List<Symbol>> groupingSets, Optional<Symbol> groupIdSymbol, List<FunctionCall> aggregates, Function<Expression, Expression> rewrite) {
        ImmutableList.Builder aggregateMappingBuilder = ImmutableList.builder();
        for (FunctionCall function : this.scopeAwareDistinct(subPlan, aggregates)) {
            Symbol symbol = this.symbolAllocator.newSymbol(function, this.analysis.getType(function));
            AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(this.analysis.getResolvedFunction(function), function.getArguments().stream().map(rewrite).collect(Collectors.toList()), function.isDistinct(), Optional.empty(), Optional.empty(), Optional.empty());
            aggregateMappingBuilder.add((Object)new AggregationAssignment(symbol, function, aggregation));
        }
        ImmutableList aggregateMappings = aggregateMappingBuilder.build();
        ImmutableSet.Builder globalGroupingSets = ImmutableSet.builder();
        for (int i = 0; i < groupingSets.size(); ++i) {
            if (!groupingSets.get(i).isEmpty()) continue;
            globalGroupingSets.add((Object)i);
        }
        ImmutableList.Builder groupingKeys = ImmutableList.builder();
        groupingSets.stream().flatMap(Collection::stream).distinct().forEach(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        groupIdSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        AggregationNode aggregationNode = new AggregationNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), (Map)aggregateMappings.stream().collect(ImmutableMap.toImmutableMap(AggregationAssignment::getSymbol, AggregationAssignment::getRewritten)), AggregationNode.groupingSets((List<Symbol>)groupingKeys.build(), groupingSets.size(), (Set<Integer>)globalGroupingSets.build()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), groupIdSymbol);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map)aggregateMappings.stream().collect(ImmutableMap.toImmutableMap(assignment -> ScopeAware.scopeAwareKey(assignment.getAstExpression(), this.analysis, subPlan.getScope()), AggregationAssignment::getSymbol))), aggregationNode);
    }

    private <T extends Expression> List<T> scopeAwareDistinct(PlanBuilder subPlan, List<T> expressions) {
        return (List)expressions.stream().map(function -> ScopeAware.scopeAwareKey(function, this.analysis, subPlan.getScope())).distinct().map(ScopeAware::getNode).collect(ImmutableList.toImmutableList());
    }

    private static List<Set<FieldId>> enumerateGroupingSets(Analysis.GroupingSetAnalysis groupingSetAnalysis) {
        List sets;
        ArrayList<List<Set<FieldId>>> partialSets = new ArrayList<List<Set<FieldId>>>();
        for (List<Set<FieldId>> cube : groupingSetAnalysis.getCubes()) {
            sets = (List)Sets.powerSet((Set)ImmutableSet.copyOf(cube)).stream().map(set -> (ImmutableSet)set.stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
            partialSets.add(sets);
        }
        for (List<Set<FieldId>> rollup : groupingSetAnalysis.getRollups()) {
            sets = (List)IntStream.rangeClosed(0, rollup.size()).mapToObj(prefixLength -> (ImmutableSet)rollup.subList(0, prefixLength).stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
            partialSets.add(sets);
        }
        partialSets.addAll(groupingSetAnalysis.getOrdinarySets());
        if (partialSets.isEmpty()) {
            return ImmutableList.of((Object)ImmutableSet.of());
        }
        ArrayList<Set<FieldId>> allSets = new ArrayList<Set<FieldId>>();
        ((List)partialSets.get(0)).stream().map(ImmutableSet::copyOf).forEach(allSets::add);
        for (int i = 1; i < partialSets.size(); ++i) {
            List groupingSets = (List)partialSets.get(i);
            ImmutableList oldGroupingSetsCrossProduct = ImmutableList.copyOf(allSets);
            allSets.clear();
            for (Set existingSet : oldGroupingSetsCrossProduct) {
                for (Set groupingSet : groupingSets) {
                    ImmutableSet concatenatedSet = ImmutableSet.builder().addAll((Iterable)existingSet).addAll((Iterable)groupingSet).build();
                    allSets.add((Set<FieldId>)concatenatedSet);
                }
            }
        }
        return allSets;
    }

    public static List<Expression> extractPatternRecognitionExpressions(List<VariableDefinition> variableDefinitions, List<MeasureDefinition> measureDefinitions) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        variableDefinitions.stream().map(VariableDefinition::getExpression).forEach(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
        measureDefinitions.stream().map(MeasureDefinition::getExpression).forEach(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
        return expressions.build();
    }

    public static Expression coerceIfNecessary(Analysis analysis, Expression original, Expression rewritten) {
        Type coercion = analysis.getCoercion(original);
        if (coercion == null) {
            return rewritten;
        }
        throw new RuntimeException("Coercion result in analysis only can be empty");
    }

    public static PlanAndMappings coerce(PlanBuilder subPlan, List<Expression> expressions, Analysis analysis, QueryId idAllocator, SymbolAllocator symbolAllocator) {
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(subPlan.getRoot().getOutputSymbols());
        HashMap<NodeRef<Expression>, Symbol> mappings = new HashMap<NodeRef<Expression>, Symbol>();
        for (Expression expression : expressions) {
            Type coercion = analysis.getCoercion(expression);
            if (mappings.containsKey(NodeRef.of(expression))) continue;
            if (coercion != null) {
                Symbol symbol = symbolAllocator.newSymbol(expression, coercion);
                assignments.put(symbol, new Cast(subPlan.rewrite(expression), null, false));
                mappings.put(NodeRef.of(expression), symbol);
                continue;
            }
            mappings.put(NodeRef.of(expression), subPlan.translate(expression));
        }
        subPlan = subPlan.withNewRoot(new ProjectNode(idAllocator.genPlanNodeId(), subPlan.getRoot(), assignments.build()));
        return new PlanAndMappings(subPlan, mappings);
    }

    public static OrderingScheme translateOrderingScheme(List<SortItem> items, Function<Expression, Symbol> coercions) {
        List coerced = (List)items.stream().map(SortItem::getSortKey).map(coercions).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder symbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orders = new HashMap<Symbol, SortOrder>();
        for (int i = 0; i < coerced.size(); ++i) {
            Symbol symbol = (Symbol)coerced.get(i);
            if (orders.containsKey(symbol)) continue;
            symbols.add((Object)symbol);
            orders.put(symbol, OrderingTranslator.sortItemToSortOrder(items.get(i)));
        }
        return new OrderingScheme((List<Symbol>)symbols.build(), orders);
    }

    private PlanBuilder gapFill(PlanBuilder subPlan, @Nonnull Symbol timeColumn, @Nonnull FunctionCall gapFillColumn, @Nonnull List<Expression> gapFillGroupingKeys, @Nonnull Expression wherePredicate) {
        Symbol gapFillColumnSymbol = subPlan.translate(gapFillColumn);
        ArrayList<Symbol> groupingKeys = new ArrayList<Symbol>(gapFillGroupingKeys.size());
        subPlan = this.fillGroup(subPlan, gapFillGroupingKeys, groupingKeys, gapFillColumnSymbol);
        int monthDuration = (int)((LongLiteral)gapFillColumn.getChildren().get(0)).getParsedValue();
        long nonMonthDuration = ((LongLiteral)gapFillColumn.getChildren().get(1)).getParsedValue();
        long origin = ((LongLiteral)gapFillColumn.getChildren().get(3)).getParsedValue();
        long[] startAndEndTime = this.getStartTimeAndEndTimeOfGapFill(timeColumn, wherePredicate, origin, monthDuration, nonMonthDuration);
        return subPlan.withNewRoot(new GapFillNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), startAndEndTime[0], startAndEndTime[1], monthDuration, nonMonthDuration, gapFillColumnSymbol, groupingKeys));
    }

    private long[] getStartTimeAndEndTimeOfGapFill(Symbol timeColumn, Expression wherePredicate, long origin, int monthDuration, long nonMonthDuration) {
        GapFillStartAndEndTimeExtractVisitor visitor = new GapFillStartAndEndTimeExtractVisitor(timeColumn);
        GapFillStartAndEndTimeExtractVisitor.Context context = new GapFillStartAndEndTimeExtractVisitor.Context();
        if (!Boolean.TRUE.equals(wherePredicate.accept(visitor, context))) {
            throw new SemanticException("could not infer startTime or endTime from WHERE clause");
        }
        return context.getTimeRange(origin, monthDuration, nonMonthDuration, this.queryContext.getZoneId());
    }

    private PlanBuilder fill(PlanBuilder subPlan, Optional<Fill> fill) {
        if (!fill.isPresent()) {
            return subPlan;
        }
        ArrayList<Symbol> groupingKeys = null;
        switch (fill.get().getFillMethod()) {
            case PREVIOUS: {
                Analysis.PreviousFillAnalysis previousFillAnalysis = (Analysis.PreviousFillAnalysis)this.analysis.getFill(fill.get());
                Symbol previousFillHelperColumn = null;
                if (previousFillAnalysis.getFieldReference().isPresent()) {
                    previousFillHelperColumn = subPlan.translate(previousFillAnalysis.getFieldReference().get());
                }
                if (previousFillAnalysis.getGroupingKeys().isPresent()) {
                    List<FieldReference> fieldReferenceList = previousFillAnalysis.getGroupingKeys().get();
                    groupingKeys = new ArrayList(fieldReferenceList.size());
                    subPlan = this.fillGroup(subPlan, fieldReferenceList, groupingKeys, previousFillHelperColumn);
                }
                return subPlan.withNewRoot(new PreviousFillNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), previousFillAnalysis.getTimeBound().orElse(null), previousFillHelperColumn, groupingKeys));
            }
            case LINEAR: {
                Analysis.LinearFillAnalysis linearFillAnalysis = (Analysis.LinearFillAnalysis)this.analysis.getFill(fill.get());
                Symbol helperColumn = subPlan.translate(linearFillAnalysis.getFieldReference());
                if (linearFillAnalysis.getGroupingKeys().isPresent()) {
                    List<FieldReference> fieldReferenceList = linearFillAnalysis.getGroupingKeys().get();
                    groupingKeys = new ArrayList<Symbol>(fieldReferenceList.size());
                    subPlan = this.fillGroup(subPlan, fieldReferenceList, groupingKeys, helperColumn);
                }
                return subPlan.withNewRoot(new LinearFillNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), helperColumn, groupingKeys));
            }
            case CONSTANT: {
                Analysis.ValueFillAnalysis valueFillAnalysis = (Analysis.ValueFillAnalysis)this.analysis.getFill(fill.get());
                return subPlan.withNewRoot(new ValueFillNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), valueFillAnalysis.getFilledValue()));
            }
        }
        throw new IllegalArgumentException("Unknown fill method: " + (Object)((Object)fill.get().getFillMethod()));
    }

    private PlanBuilder fillGroup(PlanBuilder subPlan, List<? extends Expression> groupingExpressions, List<Symbol> groupingKeys, @Nullable Symbol timeColumn) {
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (Expression expression : groupingExpressions) {
            Symbol symbol = subPlan.translate(expression);
            orderings.computeIfAbsent(symbol, k -> {
                groupingKeys.add((Symbol)k);
                orderBySymbols.add(k);
                return SortOrder.ASC_NULLS_LAST;
            });
        }
        if (timeColumn != null) {
            orderings.computeIfAbsent(timeColumn, k -> {
                orderBySymbols.add(k);
                return SortOrder.ASC_NULLS_LAST;
            });
        }
        OrderingScheme orderingScheme = new OrderingScheme((List<Symbol>)orderBySymbols.build(), orderings);
        this.analysis.setSortNode(true);
        return subPlan.withNewRoot(new SortNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), orderingScheme, false, false));
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node, List<Expression> expressions) {
        if (node.getSelect().isDistinct()) {
            List<Symbol> symbols = expressions.stream().map(subPlan::translate).collect(Collectors.toList());
            return subPlan.withNewRoot(AggregationNode.singleAggregation(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(symbols)));
        }
        return subPlan;
    }

    private Optional<OrderingScheme> orderingScheme(PlanBuilder subPlan, Optional<OrderBy> orderBy, List<Expression> orderByExpressions) {
        if (!orderBy.isPresent() || this.analysis.isOrderByRedundant(orderBy.get())) {
            return Optional.empty();
        }
        Iterator<SortItem> sortItems = orderBy.get().getSortItems().iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (Expression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            SortItem sortItem = sortItems.next();
            if (orderings.containsKey(symbol)) continue;
            orderBySymbols.add((Object)symbol);
            orderings.put(symbol, OrderingTranslator.sortItemToSortOrder(sortItem));
        }
        return Optional.of(new OrderingScheme((List<Symbol>)orderBySymbols.build(), orderings));
    }

    private PlanBuilder sort(PlanBuilder subPlan, Optional<OrderingScheme> orderingScheme) {
        if (!orderingScheme.isPresent()) {
            return subPlan;
        }
        return subPlan.withNewRoot(new SortNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), orderingScheme.get(), false, false));
    }

    private PlanBuilder offset(PlanBuilder subPlan, Optional<Offset> offset) {
        if (!offset.isPresent()) {
            return subPlan;
        }
        return subPlan.withNewRoot(new OffsetNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), this.analysis.getOffset(offset.get())));
    }

    private PlanBuilder limit(PlanBuilder subPlan, Optional<Node> limit, Optional<OrderingScheme> orderingScheme) {
        if (limit.isPresent() && this.analysis.getLimit(limit.get()).isPresent()) {
            Optional<OrderingScheme> tiesResolvingScheme = Optional.empty();
            return subPlan.withNewRoot(new LimitNode(this.queryIdAllocator.genPlanNodeId(), subPlan.getRoot(), this.analysis.getLimit(limit.get()).getAsLong(), tiesResolvingScheme));
        }
        return subPlan;
    }

    public static class PlanAndMappings {
        private final PlanBuilder subPlan;
        private final Map<NodeRef<Expression>, Symbol> mappings;

        public PlanAndMappings(PlanBuilder subPlan, Map<NodeRef<Expression>, Symbol> mappings) {
            this.subPlan = subPlan;
            this.mappings = ImmutableMap.copyOf(mappings);
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Symbol get(Expression expression) {
            return this.tryGet(expression).orElseThrow(() -> new IllegalArgumentException(String.format("No mapping for expression: %s (%s)", expression, System.identityHashCode(expression))));
        }

        public Optional<Symbol> tryGet(Expression expression) {
            Symbol result = this.mappings.get(NodeRef.of(expression));
            if (result != null) {
                return Optional.of(result);
            }
            return Optional.empty();
        }
    }

    private static class FrameBoundPlanAndSymbols {
        private final PlanBuilder subPlan;
        private final Optional<Symbol> frameBoundSymbol;
        private final Optional<Symbol> sortKeyCoercedForFrameBoundComparison;

        public FrameBoundPlanAndSymbols(PlanBuilder subPlan, Optional<Symbol> frameBoundSymbol, Optional<Symbol> sortKeyCoercedForFrameBoundComparison) {
            this.subPlan = subPlan;
            this.frameBoundSymbol = frameBoundSymbol;
            this.sortKeyCoercedForFrameBoundComparison = sortKeyCoercedForFrameBoundComparison;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Optional<Symbol> getFrameBoundSymbol() {
            return this.frameBoundSymbol;
        }

        public Optional<Symbol> getSortKeyCoercedForFrameBoundComparison() {
            return this.sortKeyCoercedForFrameBoundComparison;
        }
    }

    private static class FrameOffsetPlanAndSymbol {
        private final PlanBuilder subPlan;
        private final Optional<Symbol> frameOffsetSymbol;

        public FrameOffsetPlanAndSymbol(PlanBuilder subPlan, Optional<Symbol> frameOffsetSymbol) {
            this.subPlan = subPlan;
            this.frameOffsetSymbol = frameOffsetSymbol;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Optional<Symbol> getFrameOffsetSymbol() {
            return this.frameOffsetSymbol;
        }
    }

    private static class GroupingSetsPlan {
        private final PlanBuilder subPlan;
        private final List<Set<FieldId>> columnOnlyGroupingSets;
        private final List<List<Symbol>> groupingSets;
        private final Optional<Symbol> groupIdSymbol;

        public GroupingSetsPlan(PlanBuilder subPlan, List<Set<FieldId>> columnOnlyGroupingSets, List<List<Symbol>> groupingSets, Optional<Symbol> groupIdSymbol) {
            this.columnOnlyGroupingSets = columnOnlyGroupingSets;
            this.groupingSets = groupingSets;
            this.groupIdSymbol = groupIdSymbol;
            this.subPlan = subPlan;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public List<Set<FieldId>> getColumnOnlyGroupingSets() {
            return this.columnOnlyGroupingSets;
        }

        public List<List<Symbol>> getGroupingSets() {
            return this.groupingSets;
        }

        public Optional<Symbol> getGroupIdSymbol() {
            return this.groupIdSymbol;
        }
    }

    private static class AggregationAssignment {
        private final Symbol symbol;
        private final Expression astExpression;
        private final AggregationNode.Aggregation aggregation;

        public AggregationAssignment(Symbol symbol, Expression astExpression, AggregationNode.Aggregation aggregation) {
            this.astExpression = astExpression;
            this.symbol = symbol;
            this.aggregation = aggregation;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Expression getAstExpression() {
            return this.astExpression;
        }

        public AggregationNode.Aggregation getRewritten() {
            return this.aggregation;
        }
    }
}

