/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAnchor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrEmpty;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrExclusion;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantified;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class IrRowPattern {
    protected <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrRowPattern(this, context);
    }

    public static void serialize(IrRowPattern pattern, ByteBuffer byteBuffer) {
        if (pattern instanceof IrAlternation) {
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
            IrAlternation.serialize((IrAlternation)pattern, byteBuffer);
        } else if (pattern instanceof IrAnchor) {
            ReadWriteIOUtils.write((int)1, (ByteBuffer)byteBuffer);
            IrAnchor.serialize((IrAnchor)pattern, byteBuffer);
        } else if (pattern instanceof IrConcatenation) {
            ReadWriteIOUtils.write((int)2, (ByteBuffer)byteBuffer);
            IrConcatenation.serialize((IrConcatenation)pattern, byteBuffer);
        } else if (pattern instanceof IrEmpty) {
            ReadWriteIOUtils.write((int)3, (ByteBuffer)byteBuffer);
            IrEmpty.serialize((IrEmpty)pattern, byteBuffer);
        } else if (pattern instanceof IrExclusion) {
            ReadWriteIOUtils.write((int)4, (ByteBuffer)byteBuffer);
            IrExclusion.serialize((IrExclusion)pattern, byteBuffer);
        } else if (pattern instanceof IrLabel) {
            ReadWriteIOUtils.write((int)5, (ByteBuffer)byteBuffer);
            IrLabel.serialize((IrLabel)pattern, byteBuffer);
        } else if (pattern instanceof IrPermutation) {
            ReadWriteIOUtils.write((int)6, (ByteBuffer)byteBuffer);
            IrPermutation.serialize((IrPermutation)pattern, byteBuffer);
        } else if (pattern instanceof IrQuantified) {
            ReadWriteIOUtils.write((int)7, (ByteBuffer)byteBuffer);
            IrQuantified.serialize((IrQuantified)pattern, byteBuffer);
        } else {
            throw new SemanticException("Unknown IrRowPattern type");
        }
    }

    public static void serialize(IrRowPattern pattern, DataOutputStream stream) throws IOException {
        if (pattern instanceof IrAlternation) {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
            IrAlternation.serialize((IrAlternation)pattern, stream);
        } else if (pattern instanceof IrAnchor) {
            ReadWriteIOUtils.write((int)1, (OutputStream)stream);
            IrAnchor.serialize((IrAnchor)pattern, stream);
        } else if (pattern instanceof IrConcatenation) {
            ReadWriteIOUtils.write((int)2, (OutputStream)stream);
            IrConcatenation.serialize((IrConcatenation)pattern, stream);
        } else if (pattern instanceof IrEmpty) {
            ReadWriteIOUtils.write((int)3, (OutputStream)stream);
            IrEmpty.serialize((IrEmpty)pattern, stream);
        } else if (pattern instanceof IrExclusion) {
            ReadWriteIOUtils.write((int)4, (OutputStream)stream);
            IrExclusion.serialize((IrExclusion)pattern, stream);
        } else if (pattern instanceof IrLabel) {
            ReadWriteIOUtils.write((int)5, (OutputStream)stream);
            IrLabel.serialize((IrLabel)pattern, stream);
        } else if (pattern instanceof IrPermutation) {
            ReadWriteIOUtils.write((int)6, (OutputStream)stream);
            IrPermutation.serialize((IrPermutation)pattern, stream);
        } else if (pattern instanceof IrQuantified) {
            ReadWriteIOUtils.write((int)7, (OutputStream)stream);
            IrQuantified.serialize((IrQuantified)pattern, stream);
        } else {
            throw new SemanticException("Unknown IrRowPattern type");
        }
    }

    public static IrRowPattern deserialize(ByteBuffer byteBuffer) {
        int type = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        switch (type) {
            case 0: {
                return IrAlternation.deserialize(byteBuffer);
            }
            case 1: {
                return IrAnchor.deserialize(byteBuffer);
            }
            case 2: {
                return IrConcatenation.deserialize(byteBuffer);
            }
            case 3: {
                return IrEmpty.deserialize(byteBuffer);
            }
            case 4: {
                return IrExclusion.deserialize(byteBuffer);
            }
            case 5: {
                return IrLabel.deserialize(byteBuffer);
            }
            case 6: {
                return IrPermutation.deserialize(byteBuffer);
            }
            case 7: {
                return IrQuantified.deserialize(byteBuffer);
            }
        }
        throw new SemanticException("Unknown IrRowPattern type");
    }
}

