/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public final class CoalesceExpression
extends Expression {
    private final List<Expression> operands;

    public CoalesceExpression(Expression first, Expression second, Expression ... additional) {
        this((List<Expression>)ImmutableList.builder().add((Object[])new Expression[]{first, second}).add((Object[])additional).build());
    }

    public CoalesceExpression(List<Expression> operands) {
        super(null);
        Objects.requireNonNull(operands, "operands is null");
        Preconditions.checkArgument((operands.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least two operands");
        this.operands = ImmutableList.copyOf(operands);
    }

    public CoalesceExpression(@Nonnull NodeLocation location, List<Expression> operands) {
        super(Objects.requireNonNull(location, "location is null"));
        Objects.requireNonNull(operands, "operands is null");
        Preconditions.checkArgument((operands.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least two operands");
        this.operands = ImmutableList.copyOf(operands);
    }

    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesceExpression(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoalesceExpression that = (CoalesceExpression)o;
        return Objects.equals(this.operands, that.operands);
    }

    @Override
    public int hashCode() {
        return this.operands.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return CoalesceExpression.sameClass(this, other);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.COALESCE;
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.operands.size(), (OutputStream)stream);
        for (Expression operand : this.operands) {
            CoalesceExpression.serialize(operand, stream);
        }
    }

    public CoalesceExpression(ByteBuffer byteBuffer) {
        super(null);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.operands = new ArrayList<Expression>(size);
        while (size-- > 0) {
            this.operands.add(CoalesceExpression.deserialize(byteBuffer));
        }
    }
}

