/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ShowRegions
extends Statement {
    private final TConsensusGroupType regionType;
    private final String database;
    private final List<Integer> nodeIds;

    public ShowRegions(TConsensusGroupType regionType, String database, List<Integer> nodeIds) {
        super(null);
        this.regionType = regionType;
        this.database = database;
        this.nodeIds = nodeIds;
    }

    public TConsensusGroupType getRegionType() {
        return this.regionType;
    }

    public String getDatabase() {
        return this.database;
    }

    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowRegions(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowRegions that = (ShowRegions)o;
        return this.regionType == that.regionType && Objects.equals(this.database, that.database) && Objects.equals(this.nodeIds, that.nodeIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regionType, this.database, this.nodeIds);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("regionType", (Object)this.regionType).add("database", (Object)this.database).add("nodeIds", this.nodeIds).toString();
    }
}

