/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QueryBody;

public class Table
extends QueryBody {
    private final QualifiedName name;

    public Table(QualifiedName name) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Table(NodeLocation location, QualifiedName name) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.name, table.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Table.sameClass(this, other)) {
            return false;
        }
        Table otherTable = (Table)other;
        return this.name.equals(otherTable.name);
    }
}

