/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class StringLiteral
extends Literal {
    private final String value;

    public StringLiteral(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.STRING.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.STRING.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        if (dataType == TSDataType.TEXT || dataType == TSDataType.STRING) {
            return true;
        }
        if (dataType == TSDataType.DATE) {
            try {
                CommonUtils.parseIntFromString(this.value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.STRING.toString();
    }

    @Override
    public Binary getBinary() {
        return new Binary(this.value, TSFileConfig.STRING_CHARSET);
    }

    @Override
    public int getDate() {
        return CommonUtils.parseIntFromString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.format("\"%s\"", this.value.replace("\"", "'"));
    }
}

