/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;

public abstract class BinaryTransformer
extends Transformer {
    protected final LayerReader leftReader;
    protected final LayerReader rightReader;
    protected final TSDataType leftReaderDataType;
    protected final TSDataType rightReaderDataType;
    protected final boolean isLeftReaderConstant;
    protected final boolean isRightReaderConstant;
    protected Column[] leftColumns;
    protected Column[] rightColumns;
    protected int leftConsumed;
    protected int rightConsumed;
    protected final boolean isCurrentConstant;

    protected BinaryTransformer(LayerReader leftReader, LayerReader rightReader) {
        this.leftReader = leftReader;
        this.rightReader = rightReader;
        this.leftReaderDataType = leftReader.getDataTypes()[0];
        this.rightReaderDataType = rightReader.getDataTypes()[0];
        this.isLeftReaderConstant = leftReader.isConstantPointReader();
        this.isRightReaderConstant = rightReader.isConstantPointReader();
        this.isCurrentConstant = this.isLeftReaderConstant && this.isRightReaderConstant;
        this.checkType();
    }

    protected abstract void checkType();

    @Override
    public boolean isConstantPointReader() {
        return this.isCurrentConstant;
    }

    @Override
    public YieldableState yieldValue() throws Exception {
        YieldableState state;
        if (this.leftColumns == null) {
            state = this.leftReader.yield();
            if (state != YieldableState.YIELDABLE) {
                return state;
            }
            this.leftColumns = this.leftReader.current();
        }
        if (this.rightColumns == null) {
            state = this.rightReader.yield();
            if (state != YieldableState.YIELDABLE) {
                return state;
            }
            this.rightColumns = this.rightReader.current();
        }
        if (this.isCurrentConstant && this.cachedColumns != null) {
            return YieldableState.YIELDABLE;
        }
        int leftCount = this.leftColumns[0].getPositionCount();
        int rightCount = this.rightColumns[0].getPositionCount();
        int leftRemains = leftCount - this.leftConsumed;
        int rightRemains = rightCount - this.rightConsumed;
        int expectedEntries = Math.min(leftRemains, rightRemains);
        this.cachedColumns = this.mergeAndTransformColumns(expectedEntries);
        return YieldableState.YIELDABLE;
    }

    protected Column[] mergeAndTransformColumns(int count) throws QueryProcessException, IOException {
        TSDataType outputType = this.getDataTypes()[0];
        TimeColumnBuilder timeBuilder = new TimeColumnBuilder(null, count);
        ColumnBuilder valueBuilder = TypeUtils.initColumnBuilder(outputType, count);
        if (this.isLeftReaderConstant || this.isRightReaderConstant) {
            return this.handleConstantColumns(valueBuilder);
        }
        return this.handleNonConstantColumns((ColumnBuilder)timeBuilder, valueBuilder);
    }

    private Column[] handleNonConstantColumns(ColumnBuilder timeBuilder, ColumnBuilder valueBuilder) throws QueryProcessException, IOException {
        Column leftTimes = this.leftColumns[1];
        Column leftValues = this.leftColumns[0];
        Column rightTimes = this.rightColumns[1];
        Column rightValues = this.rightColumns[0];
        int leftEnd = leftTimes.getPositionCount();
        int rightEnd = rightTimes.getPositionCount();
        while (this.leftConsumed < leftEnd && this.rightConsumed < rightEnd) {
            long rightTime;
            long leftTime = leftTimes.getLong(this.leftConsumed);
            if (leftTime != (rightTime = rightTimes.getLong(this.rightConsumed))) {
                if (leftTime < rightTime) {
                    ++this.leftConsumed;
                    continue;
                }
                ++this.rightConsumed;
                continue;
            }
            timeBuilder.writeLong(leftTime);
            if (leftValues.isNull(this.leftConsumed) || rightValues.isNull(this.rightConsumed)) {
                valueBuilder.appendNull();
            } else {
                this.transformAndCache(leftValues, this.leftConsumed, rightValues, this.rightConsumed, valueBuilder);
            }
            ++this.leftConsumed;
            ++this.rightConsumed;
        }
        if (this.leftConsumed == leftEnd) {
            this.leftColumns = null;
            this.leftConsumed = 0;
            this.leftReader.consumedAll();
        }
        if (this.rightConsumed == rightEnd) {
            this.rightColumns = null;
            this.rightConsumed = 0;
            this.rightReader.consumedAll();
        }
        Column times = timeBuilder.build();
        Column values = valueBuilder.build();
        return new Column[]{values, times};
    }

    private Column[] handleConstantColumns(ColumnBuilder valueBuilder) throws QueryProcessException, IOException {
        if (this.isLeftReaderConstant && this.isRightReaderConstant) {
            this.transformAndCache(this.leftColumns[0], 0, this.rightColumns[0], 0, valueBuilder);
            Column constants = valueBuilder.build();
            return new Column[]{constants};
        }
        if (this.isLeftReaderConstant) {
            for (int i = 0; i < this.rightColumns[0].getPositionCount(); ++i) {
                if (this.rightColumns[0].isNull(i)) {
                    valueBuilder.appendNull();
                    continue;
                }
                this.transformAndCache(this.leftColumns[0], 0, this.rightColumns[0], i, valueBuilder);
            }
            Column times = this.rightColumns[1];
            Column values = valueBuilder.build();
            this.rightColumns = null;
            this.rightReader.consumedAll();
            return new Column[]{values, times};
        }
        if (this.isRightReaderConstant) {
            for (int i = 0; i < this.leftColumns[0].getPositionCount(); ++i) {
                if (this.leftColumns[0].isNull(i)) {
                    valueBuilder.appendNull();
                    continue;
                }
                this.transformAndCache(this.leftColumns[0], i, this.rightColumns[0], 0, valueBuilder);
            }
            Column times = this.leftColumns[1];
            Column values = valueBuilder.build();
            this.leftColumns = null;
            this.leftReader.consumedAll();
            return new Column[]{values, times};
        }
        return null;
    }

    protected abstract void transformAndCache(Column var1, int var2, Column var3, int var4, ColumnBuilder var5) throws QueryProcessException, IOException;
}

