/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.MNodeChildBuffer;

public class MNodeUpdateChildBuffer
extends MNodeChildBuffer {
    @Nullable
    public synchronized ICachedMNode put(String key, ICachedMNode value) {
        if (this.receivingBuffer == null) {
            this.receivingBuffer = new ConcurrentHashMap();
        }
        if (this.flushingBuffer == null || !this.flushingBuffer.containsKey(key)) {
            ++this.totalSize;
        }
        return this.receivingBuffer.put(key, value);
    }

    @Nullable
    public synchronized ICachedMNode putIfAbsent(String key, ICachedMNode value) {
        ICachedMNode result = this.get(this.receivingBuffer, key);
        if (result == null) {
            if (this.receivingBuffer == null) {
                this.receivingBuffer = new ConcurrentHashMap();
            }
            if (this.flushingBuffer == null || !this.flushingBuffer.containsKey(key)) {
                ++this.totalSize;
            }
            result = this.receivingBuffer.put(key, value);
        }
        return result;
    }

    public synchronized void putAll(@Nonnull Map<? extends String, ? extends ICachedMNode> m) {
        if (this.receivingBuffer == null) {
            this.receivingBuffer = new ConcurrentHashMap();
        }
        for (Map.Entry<? extends String, ? extends ICachedMNode> entry : m.entrySet()) {
            if (this.flushingBuffer == null || !this.flushingBuffer.containsKey(entry.getKey())) {
                ++this.totalSize;
            }
            this.receivingBuffer.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized ICachedMNode removeFromFlushingBuffer(Object key) {
        if (this.flushingBuffer == null) {
            return null;
        }
        ICachedMNode result = (ICachedMNode)this.flushingBuffer.remove(key);
        if (!(result == null || this.receivingBuffer != null && this.receivingBuffer.containsKey(key))) {
            --this.totalSize;
        }
        return result;
    }
}

