/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.impl;

import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.common.DeviceMNodeWrapper;
import org.apache.iotdb.commons.schema.node.info.IDeviceInfo;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IInternalMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.basic.CachedBasicMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.CachedMNodeContainer;

public class CachedBasicInternalMNode
extends CachedBasicMNode
implements IInternalMNode<ICachedMNode> {
    private volatile transient IMNodeContainer<ICachedMNode> children = null;
    private volatile IDeviceInfo<ICachedMNode> deviceInfo = null;

    public CachedBasicInternalMNode(ICachedMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey((Object)name) || this.hasChildInDeviceInfo(name);
    }

    private boolean hasChildInDeviceInfo(String name) {
        return this.deviceInfo != null && this.deviceInfo.hasAliasChild(name);
    }

    @Override
    public ICachedMNode getChild(String name) {
        ICachedMNode child = null;
        if (this.children != null) {
            child = (ICachedMNode)this.children.get((Object)name);
        }
        if (child == null && this.deviceInfo != null) {
            child = (ICachedMNode)this.deviceInfo.getAliasChild(name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode addChild(String name, ICachedMNode child) {
        if (this.children == null) {
            CachedBasicInternalMNode cachedBasicInternalMNode = this;
            synchronized (cachedBasicInternalMNode) {
                if (this.children == null) {
                    this.children = new CachedMNodeContainer();
                }
            }
        }
        child.setParent(this);
        ICachedMNode existingChild = (ICachedMNode)this.children.putIfAbsent((Object)name, (Object)child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode addChild(ICachedMNode child) {
        if (this.children == null) {
            CachedBasicInternalMNode cachedBasicInternalMNode = this;
            synchronized (cachedBasicInternalMNode) {
                if (this.children == null) {
                    this.children = new CachedMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent((Object)child.getName(), (Object)child);
        return child;
    }

    @Override
    public ICachedMNode deleteChild(String name) {
        if (this.children != null) {
            return (ICachedMNode)this.children.remove((Object)name);
        }
        return null;
    }

    @Override
    public IMNodeContainer<ICachedMNode> getChildren() {
        if (this.children == null) {
            return CachedMNodeContainer.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer<ICachedMNode> children) {
        this.children = children;
    }

    @Override
    public int estimateSize() {
        return 280 + super.estimateSize() + 8 + (this.deviceInfo == null ? 0 : this.deviceInfo.estimateSize());
    }

    @Override
    public boolean isDevice() {
        return this.getDeviceInfo() != null;
    }

    @Override
    public MNodeType getMNodeType() {
        return this.deviceInfo == null ? MNodeType.INTERNAL : MNodeType.DEVICE;
    }

    @Override
    public IInternalMNode<ICachedMNode> getAsInternalMNode() {
        return this;
    }

    @Override
    public IDeviceMNode<ICachedMNode> getAsDeviceMNode() {
        if (this.isDevice()) {
            return new DeviceMNodeWrapper((IInternalMNode)this);
        }
        throw new UnsupportedOperationException("Wrong node type");
    }

    public IDeviceInfo<ICachedMNode> getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(IDeviceInfo<ICachedMNode> deviceInfo) {
        this.deviceInfo = deviceInfo;
    }
}

