/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.tree.AbstractTreeVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.iterator.MNodeIterator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.ReentrantReadOnlyCachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MNodeUtils;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Traverser<R, N extends IMNode<N>>
extends AbstractTreeVisitor<N, R> {
    private static final Logger logger = LoggerFactory.getLogger(Traverser.class);
    protected IMTreeStore<N> store;
    protected N startNode;
    protected String[] nodes;
    protected Map<Integer, Template> templateMap;
    protected IMNodeFactory<N> nodeFactory;
    protected boolean skipPreDeletedSchema = false;
    protected boolean isPrefixMatch = false;
    private IDeviceMNode<N> skipTemplateDevice;
    private ReleaseFlushMonitor.RecordNode timeRecorder;
    private final long startTime = System.currentTimeMillis();

    protected Traverser() {
    }

    protected Traverser(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch, PathPatternTree scope) throws MetadataException {
        super(startNode, path, isPrefixMatch, scope);
        this.store = store.getWithReentrantReadLock();
        this.initStack();
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(startNode.getName())) {
            throw new IllegalPathException(path.getFullPath(), path.getFullPath() + " doesn't start with " + startNode.getName());
        }
        this.startNode = startNode;
        this.nodes = nodes;
        this.timeRecorder = store.recordTraverserStatistics();
    }

    protected Traverser(N startNode, PathPatternTree fullPathTree, IMTreeStore<N> store, PathPatternTree scope) {
        super(startNode, fullPathTree, scope);
        this.store = store.getWithReentrantReadLock();
        this.initStack();
        this.startNode = startNode;
        this.timeRecorder = store.recordTraverserStatistics();
    }

    public void traverse() throws MetadataException {
        while (this.hasNext()) {
            this.next();
        }
        if (!this.isSuccess()) {
            Throwable e = this.getFailure();
            logger.warn(e.getMessage(), e);
            throw new MetadataException(e.getMessage(), e);
        }
    }

    protected N getChild(N parent, String childName) throws MetadataException {
        return this.getChild(parent, childName, parent == this.skipTemplateDevice);
    }

    private N getChild(N parent, String childName, boolean skipTemplateChildren) throws MetadataException {
        int templateId;
        Template template;
        Object child = null;
        if (parent.isAboveDatabase()) {
            child = parent.getChild(childName);
        } else if (!(this.templateMap == null || skipTemplateChildren || this.templateMap.isEmpty() || !parent.isDevice() || parent.getAsDeviceMNode().getSchemaTemplateId() == -1 || this.skipPreDeletedSchema && parent.getAsDeviceMNode().isPreDeactivateSelfOrTemplate() || (template = this.templateMap.get(templateId = parent.getAsDeviceMNode().getSchemaTemplateId())) == null || this.nodeFactory == null)) {
            child = MNodeUtils.getChild(this.templateMap.get(templateId), childName, this.nodeFactory);
        }
        if (child == null && Objects.nonNull(child = this.store.getChild(parent, childName)) && this.skipPreDeletedSchema && child.isMeasurement() && child.getAsMeasurementMNode().isPreDeleted()) {
            child = null;
        }
        return (N)child;
    }

    protected void releaseNode(N node) {
        if (!node.isAboveDatabase() && !node.isDatabase()) {
            this.store.unPin(node);
        }
    }

    protected Iterator<N> getChildrenIterator(N parent, final Iterator<String> childrenName) throws Exception {
        return new IMNodeIterator<N>(){
            private N next = null;
            private boolean skipTemplateChildren = false;
            final /* synthetic */ IMNode val$parent;
            {
                this.val$parent = iMNode;
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.next == null && childrenName.hasNext()) {
                        try {
                            this.next = Traverser.this.getChild(this.val$parent, (String)childrenName.next(), this.skipTemplateChildren);
                        }
                        catch (Throwable e) {
                            logger.warn(e.getMessage(), e);
                            throw new RuntimeException(e);
                        }
                    }
                }
                return this.next != null;
            }

            public N next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            public void skipTemplateChildren() {
                this.skipTemplateChildren = true;
            }

            public void close() {
                if (this.next != null) {
                    Traverser.this.releaseNode(this.next);
                    this.next = null;
                }
            }
        };
    }

    protected Iterator<N> getChildrenIterator(N parent) throws MetadataException {
        if (parent.isAboveDatabase()) {
            return new MNodeIterator(parent.getChildren().values().iterator());
        }
        return this.store.getTraverserIterator(parent, this.templateMap, this.skipPreDeletedSchema);
    }

    protected void releaseNodeIterator(Iterator<N> nodeIterator) {
        if (nodeIterator instanceof IMNodeIterator) {
            ((IMNodeIterator)nodeIterator).close();
        }
    }

    public void close() {
        super.close();
        if (this.store instanceof ReentrantReadOnlyCachedMTreeStore) {
            ((ReentrantReadOnlyCachedMTreeStore)this.store).unlockRead();
        }
        long endTime = System.currentTimeMillis();
        if (this.timeRecorder != null) {
            this.timeRecorder.setEndTime(endTime);
        }
        this.store.recordTraverserMetric(endTime - this.startTime);
    }

    public void setTemplateMap(Map<Integer, Template> templateMap, IMNodeFactory<N> nodeFactory) {
        this.templateMap = templateMap;
        this.nodeFactory = nodeFactory;
    }

    public void setSkipPreDeletedSchema(boolean skipPreDeletedSchema) {
        this.skipPreDeletedSchema = skipPreDeletedSchema;
    }

    protected IFAState tryGetNextState(N node, IFAState sourceState, Map<String, IFATransition> preciseMatchTransitionMap) {
        if (node.isMeasurement()) {
            IFAState state;
            IFATransition transition;
            String alias = node.getAsMeasurementMNode().getAlias();
            if (alias != null && (transition = preciseMatchTransitionMap.get(alias)) != null && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            transition = preciseMatchTransitionMap.get(node.getName());
            if (transition != null && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            return null;
        }
        IFATransition transition = preciseMatchTransitionMap.get(node.getName());
        if (transition == null) {
            return null;
        }
        return this.patternFA.getNextState(sourceState, transition);
    }

    protected IFAState tryGetNextState(N node, IFAState sourceState, IFATransition transition) {
        if (node.isMeasurement()) {
            IFAState state;
            String alias = node.getAsMeasurementMNode().getAlias();
            if (alias != null && transition.isMatch(alias) && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            if (transition.isMatch(node.getName()) && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            return null;
        }
        if (transition.isMatch(node.getName())) {
            return this.patternFA.getNextState(sourceState, transition);
        }
        return null;
    }

    protected void skipTemplateChildren(IDeviceMNode<N> deviceMNode) {
        this.skipTemplateDevice = deviceMNode;
        Iterator iterator = this.getCurrentChildrenIterator();
        if (iterator instanceof IMNodeIterator) {
            ((IMNodeIterator)iterator).skipTemplateChildren();
        }
    }
}

