/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata;

import java.io.Serializable;
import java.util.Optional;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Preconditions;

public class PageMetadata
implements IMetadata {
    private final String measurementUid;
    private final TSDataType tsDataType;
    private Statistics<? extends Serializable> statistics;
    private boolean modified;

    public PageMetadata(String measurementUid, TSDataType tsDataType, Statistics<? extends Serializable> statistics) {
        this.measurementUid = measurementUid;
        this.tsDataType = tsDataType;
        this.statistics = statistics;
    }

    public String toString() {
        return String.format("measurementId: %s, datatype: %s, Statistics: %s", this.measurementUid, this.tsDataType, this.statistics);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getMeasurementUid() {
        return this.measurementUid;
    }

    public void setStatistics(Statistics<? extends Serializable> statistics) {
        this.statistics = statistics;
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.getStatistics();
    }

    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        Preconditions.checkArgument((measurementIndex == 0 ? 1 : 0) != 0, (String)("Non-aligned chunk only has one measurement, but measurementIndex is " + measurementIndex));
        return Optional.ofNullable(this.statistics);
    }

    public boolean hasNullValue(int measurementIndex) {
        return false;
    }
}

