/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.common;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.Element;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.MergeReaderPriority;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.reader.IPointReader;

public class PriorityMergeReader
implements IPointReader {
    protected long currentReadStopTime = Long.MIN_VALUE;
    protected PriorityQueue<Element> heap = new PriorityQueue((o1, o2) -> {
        int timeCompare = Long.compare(o1.getTimeValuePair().getTimestamp(), o2.getTimeValuePair().getTimestamp());
        return timeCompare != 0 ? timeCompare : o2.getPriority().compareTo(o1.getPriority());
    });
    protected long usedMemorySize = 0L;
    protected MemoryReservationManager memoryReservationManager;

    public void setMemoryReservationManager(MemoryReservationManager memoryReservationManager) {
        this.memoryReservationManager = memoryReservationManager;
    }

    public void addReader(IPointReader reader, MergeReaderPriority priority, long endTime) throws IOException {
        if (reader.hasNextTimeValuePair()) {
            Element element = new Element(reader, reader.nextTimeValuePair(), priority);
            this.heap.add(element);
            this.updateCurrentReadStopTime(endTime);
            long size = element.getReader().getUsedMemorySize();
            this.usedMemorySize += size;
            if (this.memoryReservationManager != null) {
                this.memoryReservationManager.reserveMemoryCumulatively(size);
            }
        } else {
            reader.close();
        }
    }

    protected void updateCurrentReadStopTime(long endTime) {
        this.currentReadStopTime = Math.max(this.currentReadStopTime, endTime);
    }

    public long getCurrentReadStopTime() {
        return this.currentReadStopTime;
    }

    public boolean hasNextTimeValuePair() {
        return !this.heap.isEmpty();
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        Element top = this.heap.poll();
        TimeValuePair ret = top.getTimeValuePair();
        TimeValuePair topNext = null;
        if (top.hasNext()) {
            top.next();
            topNext = top.currPair();
        }
        this.updateHeap(ret, topNext);
        if (topNext != null) {
            top.setTimeValuePair(topNext);
            this.heap.add(top);
        } else {
            long size = top.getReader().getUsedMemorySize();
            this.usedMemorySize -= size;
            if (this.memoryReservationManager != null) {
                this.memoryReservationManager.releaseMemoryCumulatively(size);
            }
        }
        return ret;
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        return this.heap.peek().getTimeValuePair();
    }

    protected void updateHeap(TimeValuePair ret, TimeValuePair topNext) throws IOException {
        long topNextTime;
        long topTime = ret.getTimestamp();
        long l = topNextTime = topNext == null ? Long.MAX_VALUE : topNext.getTimestamp();
        while (!this.heap.isEmpty() && this.heap.peek().currTime() == topTime) {
            long size;
            Element e = this.heap.poll();
            this.fillNullValue(ret, e.getTimeValuePair());
            if (!e.hasNext()) {
                size = e.getReader().getUsedMemorySize();
                this.usedMemorySize -= size;
                if (this.memoryReservationManager != null) {
                    this.memoryReservationManager.releaseMemoryCumulatively(size);
                }
                e.getReader().close();
                continue;
            }
            e.next();
            if (e.currTime() == topNextTime) {
                this.fillNullValue(topNext, e.getTimeValuePair());
                if (e.hasNext()) {
                    e.next();
                    this.heap.add(e);
                    continue;
                }
                size = e.getReader().getUsedMemorySize();
                this.usedMemorySize -= size;
                if (this.memoryReservationManager != null) {
                    this.memoryReservationManager.releaseMemoryCumulatively(size);
                }
                e.close();
                continue;
            }
            this.heap.add(e);
        }
    }

    protected void fillNullValue(TimeValuePair v, TimeValuePair c) {
    }

    public long getUsedMemorySize() {
        return this.usedMemorySize;
    }

    public void close() throws IOException {
        while (!this.heap.isEmpty()) {
            Element e = this.heap.poll();
            e.close();
        }
        if (this.memoryReservationManager != null) {
            this.memoryReservationManager.releaseMemoryCumulatively(this.usedMemorySize);
        }
        this.usedMemorySize = 0L;
    }
}

