/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.FloatLongPair;

public class FloatLongPairImpl
implements FloatLongPair {
    private static final long serialVersionUID = 1L;
    private final float one;
    private final long two;

    FloatLongPairImpl(float newOne, long newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public float getOne() {
        return this.one;
    }

    @Override
    public long getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatLongPair)) {
            return false;
        }
        FloatLongPair that = (FloatLongPair)o;
        return Float.compare(this.one, that.getOne()) == 0 && this.two == that.getTwo();
    }

    public int hashCode() {
        return 29 * Float.floatToIntBits(this.one) + (int)(this.two ^ this.two >>> 32);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(FloatLongPair that) {
        int i = Float.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return this.two < that.getTwo() ? -1 : (this.two > that.getTwo() ? 1 : 0);
    }
}

