/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import sun.misc.Cleaner;

public class UnsignedByteLargeArray
extends LargeArray {
    private static final long serialVersionUID = 3135411647495793832L;
    private byte[] data;

    public UnsignedByteLargeArray(long length) {
        this(length, true);
    }

    public UnsignedByteLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        if (length > (long)UnsignedByteLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(length);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new byte[(int)length];
        }
    }

    public UnsignedByteLargeArray(long length, short constantValue) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        if (constantValue < 0 || constantValue > 255) {
            throw new IllegalArgumentException("The value cannot be smaller than 0 or greater than 255");
        }
        this.data = new byte[]{(byte)constantValue};
    }

    public UnsignedByteLargeArray(byte[] data) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = data;
    }

    public UnsignedByteLargeArray(short[] data) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = new byte[data.length];
        int i = 0;
        while ((long)i < this.length) {
            short elem = data[i];
            if (elem < 0 || elem > 255) {
                throw new IllegalArgumentException("The value cannot be smaller than 0 or greater than 255");
            }
            this.data[i] = (byte)elem;
            ++i;
        }
    }

    @Override
    public UnsignedByteLargeArray clone() {
        if (this.isConstant) {
            return new UnsignedByteLargeArray(this.length, this.getByte(0L));
        }
        UnsignedByteLargeArray v = new UnsignedByteLargeArray(this.length, false);
        LargeArrayUtils.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            UnsignedByteLargeArray la = (UnsignedByteLargeArray)o;
            return this.data == la.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
    }

    @Override
    public final Short get(long i) {
        return this.getUnsignedByte(i);
    }

    @Override
    public final Byte getFromNative(long i) {
        return LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
    }

    @Override
    public final boolean getBoolean(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i) != 0;
        }
        if (this.isConstant) {
            return this.data[0] != 0;
        }
        return this.data[(int)i] != 0;
    }

    @Override
    public final byte getByte(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public final short getUnsignedByte(long i) {
        if (this.ptr != 0L) {
            return (short)(0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i));
        }
        if (this.isConstant) {
            return (short)(0xFF & this.data[0]);
        }
        return (short)(0xFF & this.data[(int)i]);
    }

    @Override
    public final short getShort(long i) {
        return this.getUnsignedByte(i);
    }

    @Override
    public final int getInt(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final long getLong(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final float getFloat(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final double getDouble(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                byte v = LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
                out[idx++] = v != 0;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0;
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = elem;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                byte v = this.data[(int)i];
                out[idx++] = v != 0;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                byte v = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                out[i] = v != 0;
                ++i;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i] != 0;
                ++i;
            }
        }
        return out;
    }

    public final byte[] getData() {
        return this.data;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            System.arraycopy(this.data, 0, out, 0, (int)this.length);
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            short elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i));
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & this.data[0]);
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & this.data[(int)i]);
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            int elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len > 0x40000000L) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i, Object value) {
        LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (Byte)value);
    }

    @Override
    public final void setBoolean(long i, boolean value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, value ? (byte)1 : 0);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value ? (byte)1 : 0;
        }
    }

    @Override
    public final void setByte(long i, byte value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setUnsignedByte(long i, short value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("The value cannot be smaller than 0 or greater than 255");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)value;
        }
    }

    @Override
    public final void setShort(long i, short value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFF & value));
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)(0xFF & value);
        }
    }

    @Override
    public final void setInt(long i, int value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFF & value));
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)(0xFF & value);
        }
    }

    @Override
    public final void setLong(long i, long value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFFL & value));
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)(0xFFL & value);
        }
    }

    @Override
    public final void setFloat(long i, float value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFF & (int)value));
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)(0xFF & (int)value);
        }
    }

    @Override
    public final void setDouble(long i, double value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFFL & (long)value));
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (byte)(0xFFL & (long)value);
        }
    }
}

