/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;
import org.apache.james.jdkim.impl.MultiplexingPublicKeyRecordRetriever;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Sets;
import org.junit.Test;

public class MultiplexingPublicKeyRecordRetrieverTest {
    private final PublicKeyRecordRetriever myMethodRetriever = (methodAndOption, selector, token) -> {
        ArrayList<String> l = new ArrayList<String>();
        l.add(selector.toString());
        l.add(token.toString());
        return l;
    };

    @Test
    public void should_retrieve_records_by_known_method() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever pkrr = new MultiplexingPublicKeyRecordRetriever("mymethod", this.myMethodRetriever);
        this.check(pkrr, "mymethod");
    }

    @Test
    public void should_retrieve_records_by_known_method_with_options() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever pkrr = new MultiplexingPublicKeyRecordRetriever("mymethod", this.myMethodRetriever);
        this.check(pkrr, "mymethod/option");
    }

    @Test
    public void should_fail_on_unknown_method() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever retriever = new MultiplexingPublicKeyRecordRetriever("mymethod", this.myMethodRetriever);
        this.check(retriever, "mymethod");
        Assertions.assertThatThrownBy(() -> retriever.getRecords((CharSequence)"unknownMethod", (CharSequence)"selector", (CharSequence)"token")).isInstanceOf(FailException.class);
    }

    @Test
    public void should_retrieve_records_from_several_known_methods() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever retriever = new MultiplexingPublicKeyRecordRetriever(Sets.set((Object[])new MultiplexingPublicKeyRecordRetriever.Entry[]{MultiplexingPublicKeyRecordRetriever.Entry.of((String)"myMethod", (PublicKeyRecordRetriever)this.myMethodRetriever), MultiplexingPublicKeyRecordRetriever.Entry.of((String)"myOtherMethod", (PublicKeyRecordRetriever)this.myMethodRetriever)}));
        this.check(retriever, "myMethod");
        this.check(retriever, "myOtherMethod");
        Assertions.assertThatThrownBy(() -> retriever.getRecords((CharSequence)"unknownMethod", (CharSequence)"selector", (CharSequence)"token")).isInstanceOf(FailException.class);
    }

    @Test
    public void should_retrieve_records_from_several_known_methods_with_mixed_option() throws TempFailException, PermFailException {
        MultiplexingPublicKeyRecordRetriever retriever = new MultiplexingPublicKeyRecordRetriever(Sets.set((Object[])new MultiplexingPublicKeyRecordRetriever.Entry[]{MultiplexingPublicKeyRecordRetriever.Entry.of((String)"myMethod", (PublicKeyRecordRetriever)this.myMethodRetriever), MultiplexingPublicKeyRecordRetriever.Entry.of((String)"myOtherMethod", (PublicKeyRecordRetriever)this.myMethodRetriever)}));
        this.check(retriever, "myMethod");
        this.check(retriever, "myMethod/option");
        this.check(retriever, "myOtherMethod");
        this.check(retriever, "myOtherMethod/option");
        Assertions.assertThatThrownBy(() -> retriever.getRecords((CharSequence)"unknownMethod", (CharSequence)"selector", (CharSequence)"token")).isInstanceOf(FailException.class);
        Assertions.assertThatThrownBy(() -> retriever.getRecords((CharSequence)"unknownMethod/option", (CharSequence)"selector", (CharSequence)"token")).isInstanceOf(FailException.class);
    }

    private void check(MultiplexingPublicKeyRecordRetriever pkrr, String method) throws TempFailException, PermFailException {
        List records = pkrr.getRecords((CharSequence)method, (CharSequence)"selector", (CharSequence)"token");
        Assertions.assertThat((List)records).containsExactly((Object[])new String[]{"selector", "token"});
    }
}

