/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.LogEnabled;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.ConfigurationEnabled;
import org.apache.james.jspf.terms.Modifier;

public abstract class GenericModifier
implements Modifier,
ConfigurationEnabled,
LogEnabled {
    private String host;
    protected Logger log;

    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        this.log.debug("Processing modifier: " + this);
        DNSLookupContinuation res = this.checkSPFLogged(spfData);
        this.log.debug("Processed modifier: " + this + " resulted in " + res == null ? spfData.getCurrentResult() : " dns continuation...");
        return res;
    }

    protected abstract DNSLookupContinuation checkSPFLogged(SPFSession var1) throws PermErrorException, TempErrorException, NeutralException, NoneException;

    public boolean enforceSingleInstance() {
        return true;
    }

    public synchronized void config(Configuration params) throws PermErrorException {
        if (params.groupCount() > 0) {
            this.host = params.group(1);
        }
    }

    protected synchronized String getHost() {
        return this.host;
    }

    public void enableLogging(Logger logger) {
        this.log = logger;
    }
}

