/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailCmdHandler
extends AbstractHookableCmdHandler<MailHook> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"MAIL");
    private static final Logger LOGGER = LoggerFactory.getLogger(MailCmdHandler.class);
    private static final Response SENDER_ALREADY_SPECIFIED = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Sender already specified").immutable();
    private static final Response EHLO_HELO_NEEDED = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Need HELO or EHLO before MAIL").immutable();
    private static final Response SYNTAX_ERROR_ARG = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Usage: MAIL FROM:<sender>").immutable();
    private static final Response SYNTAX_ERROR = new SMTPResponse("501", DSNStatus.getStatus(5, "1.7") + " Syntax error in MAIL command").immutable();
    private static final Response SYNTAX_ERROR_ADDRESS = new SMTPResponse("501", DSNStatus.getStatus(5, "1.7") + " Syntax error in sender address").immutable();
    private Map<String, MailParametersHook> paramHooks;

    @Inject
    public MailCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    @Override
    public Response onCommand(SMTPSession session, Request request) {
        Response response = super.onCommand(session, request);
        if (!response.getRetCode().equals("250")) {
            session.removeAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction);
        }
        return response;
    }

    private Response doMAIL(SMTPSession session) {
        StringBuilder responseBuffer = new StringBuilder();
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        responseBuffer.append(DSNStatus.getStatus(2, "1.0")).append(" Sender <");
        if (!sender.isNullSender()) {
            responseBuffer.append(sender.asString());
        }
        responseBuffer.append("> OK");
        return new SMTPResponse("250", responseBuffer);
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doMAIL(session);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        return this.doMAILFilter(session, parameters);
    }

    private Response doMAILFilter(SMTPSession session, String argument) {
        String sender = null;
        if (argument != null && argument.indexOf(":") > 0) {
            int colonIndex = argument.indexOf(":");
            sender = argument.substring(colonIndex + 1);
            argument = argument.substring(0, colonIndex);
        }
        if (session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).isPresent()) {
            return SENDER_ALREADY_SPECIFIED;
        }
        if (!session.getAttachment(SMTPSession.CURRENT_HELO_MODE, ProtocolSession.State.Connection).isPresent() && session.getConfiguration().useHeloEhloEnforcement()) {
            return EHLO_HELO_NEEDED;
        }
        if (argument == null || !argument.toUpperCase(Locale.US).equals("FROM") || sender == null) {
            return SYNTAX_ERROR_ARG;
        }
        int lastChar = (sender = sender.trim()).indexOf(62, sender.indexOf(60));
        if (lastChar > 0 && sender.length() > lastChar + 2 && sender.charAt(lastChar + 1) == ' ') {
            String mailOptionString = sender.substring(lastChar + 2);
            sender = sender.substring(0, lastChar + 1);
            StringTokenizer optionTokenizer = new StringTokenizer(mailOptionString, " ");
            while (optionTokenizer.hasMoreElements()) {
                String mailOption = optionTokenizer.nextToken();
                int equalIndex = mailOption.indexOf(61);
                String mailOptionName = mailOption;
                String mailOptionValue = "";
                if (equalIndex > 0) {
                    mailOptionName = mailOption.substring(0, equalIndex).toUpperCase(Locale.US);
                    mailOptionValue = mailOption.substring(equalIndex + 1);
                }
                if (this.paramHooks.containsKey(mailOptionName)) {
                    MailParametersHook hook = this.paramHooks.get(mailOptionName);
                    SMTPResponse res = MailCmdHandler.calcDefaultSMTPResponse(hook.doMailParameter(session, mailOptionName, mailOptionValue));
                    if (res == null) continue;
                    return res;
                }
                LOGGER.debug("MAIL command had unrecognized/unexpected option {} with value {}", (Object)mailOptionName, (Object)mailOptionValue);
            }
        }
        if (!(!session.getConfiguration().useAddressBracketsEnforcement() || sender.startsWith("<") && sender.endsWith(">"))) {
            LOGGER.info("Error parsing sender address: {}: did not start and end with < >", (Object)sender);
            return SYNTAX_ERROR;
        }
        try {
            MaybeSender senderAddress = this.toMaybeSender(this.removeBrackets(sender));
            session.setAttachment(SMTPSession.SENDER, senderAddress, ProtocolSession.State.Transaction);
        }
        catch (Exception pe) {
            LOGGER.info("Error parsing sender address: {}", (Object)sender, (Object)pe);
            return SYNTAX_ERROR_ADDRESS;
        }
        return null;
    }

    private MaybeSender toMaybeSender(String senderAsString) throws AddressException {
        if (senderAsString.length() == 0) {
            return MaybeSender.nullSender();
        }
        if (senderAsString.equals("@")) {
            return MaybeSender.nullSender();
        }
        return MaybeSender.of((MailAddress)new MailAddress(this.appendDefaultDomainIfNeeded(senderAsString)));
    }

    private String removeBrackets(String input) {
        if (input.startsWith("<") && input.endsWith(">")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    private String appendDefaultDomainIfNeeded(String address) {
        if (!address.contains("@")) {
            return address + "@" + this.getDefaultDomain();
        }
        return address;
    }

    @Override
    protected Class<MailHook> getHookInterface() {
        return MailHook.class;
    }

    @Override
    protected HookResult callHook(MailHook rawHook, SMTPSession session, String parameters) {
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        return rawHook.doMail(session, sender);
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        List<Class<?>> l = super.getMarkerInterfaces();
        l.add(MailParametersHook.class);
        return l;
    }

    @Override
    public void wireExtensions(Class interfaceName, List extension) {
        if (MailParametersHook.class.equals((Object)interfaceName)) {
            this.paramHooks = new HashMap<String, MailParametersHook>();
            for (MailParametersHook hook : extension) {
                String[] params;
                for (String param : params = hook.getMailParamNames()) {
                    this.paramHooks.put(param, hook);
                }
            }
        } else {
            super.wireExtensions(interfaceName, extension);
        }
    }

    protected String getDefaultDomain() {
        return "localhost";
    }
}

