/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.NoOpMetricsCollector;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import com.rabbitmq.client.impl.ConsumerWorkService;
import com.rabbitmq.client.impl.Environment;
import com.rabbitmq.client.impl.UnknownChannelException;
import com.rabbitmq.utility.IntAllocator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private final Object monitor = new Object();
    private final Map<Integer, ChannelN> _channelMap = new HashMap<Integer, ChannelN>();
    private final IntAllocator channelNumberAllocator;
    private final ConsumerWorkService workService;
    private final Set<CountDownLatch> shutdownSet = new HashSet<CountDownLatch>();
    private final int _channelMax;
    private ExecutorService shutdownExecutor;
    private final ThreadFactory threadFactory;
    private int channelShutdownTimeout = 63000;
    protected final MetricsCollector metricsCollector;

    public int getChannelMax() {
        return this._channelMax;
    }

    public ChannelManager(ConsumerWorkService workService, int channelMax) {
        this(workService, channelMax, Executors.defaultThreadFactory());
    }

    public ChannelManager(ConsumerWorkService workService, int channelMax, ThreadFactory threadFactory) {
        this(workService, channelMax, threadFactory, new NoOpMetricsCollector());
    }

    public ChannelManager(ConsumerWorkService workService, int channelMax, ThreadFactory threadFactory, MetricsCollector metricsCollector) {
        if (channelMax < 0) {
            throw new IllegalArgumentException("create ChannelManager: 'channelMax' must be greater or equal to 0.");
        }
        if (channelMax == 0) {
            channelMax = 65535;
        }
        this._channelMax = channelMax;
        this.channelNumberAllocator = new IntAllocator(1, channelMax);
        this.workService = workService;
        this.threadFactory = threadFactory;
        this.metricsCollector = metricsCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN getChannel(int channelNumber) {
        Object object = this.monitor;
        synchronized (object) {
            ChannelN ch = this._channelMap.get(channelNumber);
            if (ch == null) {
                throw new UnknownChannelException(channelNumber);
            }
            return ch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSignal(final ShutdownSignalException signal) {
        HashSet<ChannelN> channels;
        Iterator iterator = this.monitor;
        synchronized (iterator) {
            channels = new HashSet<ChannelN>(this._channelMap.values());
        }
        for (final ChannelN channel : channels) {
            this.releaseChannelNumber(channel);
            Runnable channelShutdownRunnable = new Runnable(){

                @Override
                public void run() {
                    channel.processShutdownSignal(signal, true, true);
                }
            };
            if (this.shutdownExecutor == null) {
                channelShutdownRunnable.run();
            } else {
                Future<?> channelShutdownTask = this.shutdownExecutor.submit(channelShutdownRunnable);
                try {
                    channelShutdownTask.get(this.channelShutdownTimeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOGGER.warn("Couldn't properly close channel {} on shutdown after waiting for {} ms", (Object)channel.getChannelNumber(), (Object)this.channelShutdownTimeout);
                    channelShutdownTask.cancel(true);
                }
            }
            this.shutdownSet.add(channel.getShutdownLatch());
            channel.notifyListeners();
        }
        this.scheduleShutdownProcessing();
    }

    private void scheduleShutdownProcessing() {
        final HashSet<CountDownLatch> sdSet = new HashSet<CountDownLatch>(this.shutdownSet);
        final ConsumerWorkService ssWorkService = this.workService;
        Runnable target = new Runnable(){

            @Override
            public void run() {
                for (CountDownLatch latch : sdSet) {
                    try {
                        int shutdownTimeout = ssWorkService.getShutdownTimeout();
                        if (shutdownTimeout == 0) {
                            latch.await();
                            continue;
                        }
                        boolean completed = latch.await(shutdownTimeout, TimeUnit.MILLISECONDS);
                        if (completed) continue;
                        LOGGER.warn("Consumer dispatcher for channel didn't shutdown after waiting for {} ms", (Object)shutdownTimeout);
                    }
                    catch (Throwable throwable) {}
                }
                ssWorkService.shutdown();
            }
        };
        if (this.shutdownExecutor != null) {
            this.shutdownExecutor.execute(target);
        } else {
            Thread shutdownThread = Environment.newThread(this.threadFactory, target, "ConsumerWorkService shutdown monitor", true);
            shutdownThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection connection) throws IOException {
        ChannelN ch;
        Object object = this.monitor;
        synchronized (object) {
            int channelNumber = this.channelNumberAllocator.allocate();
            if (channelNumber == -1) {
                return null;
            }
            ch = this.addNewChannel(connection, channelNumber);
        }
        ch.open();
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelN createChannel(AMQConnection connection, int channelNumber) throws IOException {
        ChannelN ch;
        Object object = this.monitor;
        synchronized (object) {
            if (!this.channelNumberAllocator.reserve(channelNumber)) {
                return null;
            }
            ch = this.addNewChannel(connection, channelNumber);
        }
        ch.open();
        return ch;
    }

    private ChannelN addNewChannel(AMQConnection connection, int channelNumber) {
        if (this._channelMap.containsKey(channelNumber)) {
            throw new IllegalStateException("We have attempted to create a channel with a number that is already in use. This should never happen. Please report this as a bug.");
        }
        ChannelN ch = this.instantiateChannel(connection, channelNumber, this.workService);
        this._channelMap.put(ch.getChannelNumber(), ch);
        return ch;
    }

    protected ChannelN instantiateChannel(AMQConnection connection, int channelNumber, ConsumerWorkService workService) {
        return new ChannelN(connection, channelNumber, workService, this.metricsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseChannelNumber(ChannelN channel) {
        Object object = this.monitor;
        synchronized (object) {
            int channelNumber = channel.getChannelNumber();
            ChannelN existing = this._channelMap.remove(channelNumber);
            if (existing == null) {
                return;
            }
            if (existing != channel) {
                this._channelMap.put(channelNumber, existing);
                return;
            }
            this.channelNumberAllocator.free(channelNumber);
        }
    }

    public ExecutorService getShutdownExecutor() {
        return this.shutdownExecutor;
    }

    public void setShutdownExecutor(ExecutorService shutdownExecutor) {
        this.shutdownExecutor = shutdownExecutor;
    }

    public void setChannelShutdownTimeout(int channelShutdownTimeout) {
        this.channelShutdownTimeout = channelShutdownTimeout;
    }
}

