/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.search;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.search.Criterion;

public class Query {
    public static final Query ALL = new Query((List<Criterion<?>>)ImmutableList.of());
    private static final Predicate<DeletedMessage> MATCH_ALL = any -> true;
    private final List<Criterion<?>> criteria;

    public static Query and(List<Criterion<?>> criteria) {
        return new Query(criteria);
    }

    public static Query of(Criterion<?> ... criteria) {
        return new Query((List<Criterion<?>>)ImmutableList.copyOf((Object[])criteria));
    }

    private Query(List<Criterion<?>> criteria) {
        this.criteria = criteria;
    }

    public Predicate<DeletedMessage> toPredicate() {
        return this.criteria.stream().map(Criterion::toPredicate).reduce(Predicate::and).orElse(MATCH_ALL);
    }

    public List<Criterion<?>> getCriteria() {
        return this.criteria;
    }
}

