/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7.json;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.james.mailbox.elasticsearch.v7.json.MimePart;
import org.apache.james.mailbox.elasticsearch.v7.json.MimePartContainerBuilder;
import org.apache.james.mailbox.elasticsearch.v7.json.RootMimePartContainerBuilder;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.DefaultBodyDescriptorBuilder;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimePartParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimePartParser.class);
    private static final LenientFieldParser FIELD_PARSER = new LenientFieldParser();
    private final Message message;
    private final TextExtractor textExtractor;
    private final MimeTokenStream stream;
    private final Deque<MimePartContainerBuilder> builderStack;
    private MimePart result;
    private MimePartContainerBuilder currentlyBuildMimePart;

    public MimePartParser(Message message, TextExtractor textExtractor) {
        this.message = message;
        this.textExtractor = textExtractor;
        this.builderStack = new LinkedList<MimePartContainerBuilder>();
        this.currentlyBuildMimePart = new RootMimePartContainerBuilder();
        this.stream = new MimeTokenStream(MimeConfig.PERMISSIVE, (BodyDescriptorBuilder)new DefaultBodyDescriptorBuilder(null, (FieldParser)FIELD_PARSER, DecodeMonitor.SILENT));
    }

    public MimePart parse() throws IOException, MimeException {
        this.stream.parse(this.message.getFullContent());
        EntityState state = this.stream.getState();
        while (state != EntityState.T_END_OF_STREAM) {
            this.processMimePart(this.stream, state);
            state = this.stream.next();
        }
        return this.result;
    }

    private void processMimePart(MimeTokenStream stream, EntityState state) {
        switch (state) {
            case T_START_MULTIPART: 
            case T_START_MESSAGE: {
                this.stackCurrent();
                break;
            }
            case T_START_HEADER: {
                this.currentlyBuildMimePart = MimePart.builder();
                break;
            }
            case T_FIELD: {
                this.currentlyBuildMimePart.addToHeaders(stream.getField());
                break;
            }
            case T_BODY: {
                this.manageBodyExtraction(stream);
                this.closeMimePart();
                break;
            }
            case T_END_MULTIPART: 
            case T_END_MESSAGE: {
                this.unstackToCurrent();
                this.closeMimePart();
                break;
            }
        }
    }

    private void stackCurrent() {
        this.builderStack.push(this.currentlyBuildMimePart);
        this.currentlyBuildMimePart = null;
    }

    private void unstackToCurrent() {
        this.currentlyBuildMimePart = this.builderStack.pop();
    }

    private void closeMimePart() {
        MimePart bodyMimePart = this.currentlyBuildMimePart.using(this.textExtractor).build();
        if (!this.builderStack.isEmpty()) {
            this.builderStack.peek().addChild(bodyMimePart);
        } else {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0);
            this.result = bodyMimePart;
        }
    }

    private void manageBodyExtraction(MimeTokenStream stream) {
        this.extractMimePartBodyDescription(stream);
        this.currentlyBuildMimePart.addBodyContent(stream.getDecodedInputStream());
    }

    private void extractMimePartBodyDescription(MimeTokenStream stream) {
        MaximalBodyDescriptor descriptor = (MaximalBodyDescriptor)stream.getBodyDescriptor();
        Optional.ofNullable(descriptor.getMediaType()).map(ContentType.MediaType::of).ifPresent(this.currentlyBuildMimePart::addMediaType);
        Optional.ofNullable(descriptor.getSubType()).map(ContentType.SubType::of).ifPresent(this.currentlyBuildMimePart::addSubType);
        this.currentlyBuildMimePart.addContentDisposition(descriptor.getContentDispositionType()).addFileName(descriptor.getContentDispositionFilename());
        this.extractCharset(descriptor);
    }

    private void extractCharset(MaximalBodyDescriptor descriptor) {
        try {
            Optional.ofNullable(descriptor.getCharset()).map(Charset::forName).ifPresent(this.currentlyBuildMimePart::charset);
        }
        catch (Exception e) {
            LOGGER.info("Failed parsing charset", (Throwable)e);
        }
    }
}

