/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasTask;
import org.apache.james.mailbox.quota.task.RunningOptionsDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class RecomputeCurrentQuotasTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final long processedQuotaRoots;
    private final ImmutableList<String> failedQuotaRoots;
    private final Optional<RunningOptionsDTO> runningOptions;
    private final Instant timestamp;

    private static RecomputeCurrentQuotasTaskAdditionalInformationDTO fromDomainObject(RecomputeCurrentQuotasTask.Details details, String type) {
        return new RecomputeCurrentQuotasTaskAdditionalInformationDTO(type, details.getProcessedQuotaRoots(), details.getFailedQuotaRoots(), Optional.of(RunningOptionsDTO.asDTO(details.getRunningOptions())), details.timestamp());
    }

    public static AdditionalInformationDTOModule<RecomputeCurrentQuotasTask.Details, RecomputeCurrentQuotasTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(RecomputeCurrentQuotasTask.Details.class).convertToDTO(RecomputeCurrentQuotasTaskAdditionalInformationDTO.class).toDomainObjectConverter(RecomputeCurrentQuotasTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(RecomputeCurrentQuotasTaskAdditionalInformationDTO::fromDomainObject).typeName(RecomputeCurrentQuotasTask.RECOMPUTE_CURRENT_QUOTAS.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public RecomputeCurrentQuotasTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="processedQuotaRoots") long processedQuotaRoots, @JsonProperty(value="failedQuotaRoots") ImmutableList<String> failedQuotaRoots, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.processedQuotaRoots = processedQuotaRoots;
        this.failedQuotaRoots = failedQuotaRoots;
        this.runningOptions = runningOptions;
        this.timestamp = timestamp;
    }

    public long getProcessedQuotaRoots() {
        return this.processedQuotaRoots;
    }

    public ImmutableList<String> getFailedQuotaRoots() {
        return this.failedQuotaRoots;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }

    private RecomputeCurrentQuotasTask.Details toDomainObject() {
        return new RecomputeCurrentQuotasTask.Details(this.timestamp, this.processedQuotaRoots, this.failedQuotaRoots, this.runningOptions.map(RunningOptionsDTO::asDomainObject).orElse(RecomputeCurrentQuotasService.RunningOptions.DEFAULT));
    }
}

