/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ForwardDestinationResponse;
import org.apache.james.webadmin.routes.MailAddressParser;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class ForwardRoutes
implements Routes {
    public static final String ROOT_PATH = "address/forwards";
    private static final String FORWARD_BASE_ADDRESS = "forwardBaseAddress";
    private static final String FORWARD_ADDRESS_PATH = "address/forwards/:forwardBaseAddress";
    private static final String FORWARD_DESTINATION_ADDRESS = "forwardDestinationAddress";
    private static final String USER_IN_FORWARD_DESTINATION_ADDRESSES_PATH = "address/forwards/:forwardBaseAddress/targets/:forwardDestinationAddress";
    private static final String FORWARD_BASE_ADDRESS_TYPE = "base forward";
    private static final String FORWARD_DESTINATION_ADDRESS_TYPE = "target forward";
    private final UsersRepository usersRepository;
    private final JsonTransformer jsonTransformer;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    @VisibleForTesting
    ForwardRoutes(RecipientRewriteTable recipientRewriteTable, UsersRepository usersRepository, JsonTransformer jsonTransformer) {
        this.usersRepository = usersRepository;
        this.jsonTransformer = jsonTransformer;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.get(ROOT_PATH, this::listForwards, (ResponseTransformer)this.jsonTransformer);
        service.get(FORWARD_ADDRESS_PATH, this::listForwardDestinations, (ResponseTransformer)this.jsonTransformer);
        service.put(FORWARD_ADDRESS_PATH, this::throwUnknownPath);
        service.put(USER_IN_FORWARD_DESTINATION_ADDRESSES_PATH, this::addToForwardDestinations);
        service.delete(FORWARD_ADDRESS_PATH, this::throwUnknownPath);
        service.delete(USER_IN_FORWARD_DESTINATION_ADDRESSES_PATH, this::removeFromForwardDestination);
    }

    public Object throwUnknownPath(Request request, Response response) {
        throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("A destination address needs to be specified in the path").haltError();
    }

    public List<MappingSource> listForwards(Request request, Response response) throws RecipientRewriteTableException {
        return (List)this.recipientRewriteTable.getSourcesForType(Mapping.Type.Forward).collect(ImmutableList.toImmutableList());
    }

    public HaltException addToForwardDestinations(Request request, Response response) throws RecipientRewriteTableException, UsersRepositoryException {
        MailAddress forwardBaseAddress = MailAddressParser.parseMailAddress(request.params(FORWARD_BASE_ADDRESS), FORWARD_BASE_ADDRESS_TYPE);
        this.ensureUserExist(forwardBaseAddress);
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(FORWARD_DESTINATION_ADDRESS), FORWARD_DESTINATION_ADDRESS_TYPE);
        MappingSource source = MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)forwardBaseAddress.getLocalPart(), (Domain)forwardBaseAddress.getDomain()));
        this.addForward(source, destinationAddress);
        return Spark.halt((int)204);
    }

    private void addForward(MappingSource source, MailAddress destinationAddress) throws RecipientRewriteTableException {
        try {
            this.recipientRewriteTable.addForwardMapping(source, destinationAddress.asString());
        }
        catch (MappingAlreadyExistsException mappingAlreadyExistsException) {
        }
        catch (SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        catch (LoopDetectedException e) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).haltError();
        }
    }

    private void ensureUserExist(MailAddress mailAddress) throws UsersRepositoryException {
        if (!this.usersRepository.contains(this.usersRepository.getUsername(mailAddress))) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Requested base forward address does not correspond to a user").haltError();
        }
    }

    public HaltException removeFromForwardDestination(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress baseAddress = MailAddressParser.parseMailAddress(request.params(FORWARD_BASE_ADDRESS), FORWARD_BASE_ADDRESS_TYPE);
        MailAddress destinationAddressToBeRemoved = MailAddressParser.parseMailAddress(request.params(FORWARD_DESTINATION_ADDRESS), FORWARD_DESTINATION_ADDRESS_TYPE);
        MappingSource source = MappingSource.fromUser((Username)Username.fromLocalPartWithDomain((String)baseAddress.getLocalPart(), (Domain)baseAddress.getDomain()));
        this.recipientRewriteTable.removeForwardMapping(source, destinationAddressToBeRemoved.asString());
        return Spark.halt((int)204);
    }

    public ImmutableSet<ForwardDestinationResponse> listForwardDestinations(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress baseAddress = MailAddressParser.parseMailAddress(request.params(FORWARD_BASE_ADDRESS), FORWARD_BASE_ADDRESS_TYPE);
        Mappings mappings = this.recipientRewriteTable.getStoredMappings(MappingSource.fromMailAddress((MailAddress)baseAddress)).select(Mapping.Type.Forward);
        this.ensureNonEmptyMappings(mappings);
        return (ImmutableSet)mappings.asStream().map(mapping -> (MailAddress)mapping.asMailAddress().orElseThrow(() -> new IllegalStateException(String.format("Can not compute address for mapping %s", mapping.asString())))).map(MailAddress::asString).sorted().map(ForwardDestinationResponse::new).collect(ImmutableSet.toImmutableSet());
    }

    private void ensureNonEmptyMappings(Mappings mappings) {
        if (mappings == null || mappings.isEmpty()) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The forward does not exist").haltError();
        }
    }
}

