/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionCompat
extends QueryExecutionAdapter {
    private final QueryExecMod qExecBuilder;
    private volatile QueryExec qExecHere = null;
    private final Dataset datasetHere;
    private final Query queryHere;

    public static QueryExecution compatibility(QueryExecMod qExec, Dataset dataset, Query query, String queryString) {
        return new QueryExecutionCompat(qExec, dataset, query);
    }

    private QueryExecutionCompat(QueryExecMod qExecBuilder, Dataset dataset, Query query) {
        super(null);
        this.qExecBuilder = qExecBuilder;
        this.datasetHere = dataset;
        this.queryHere = query;
    }

    @Override
    protected QueryExec get() {
        this.execution();
        return this.qExecHere;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execution() {
        if (this.qExecHere == null) {
            QueryExecutionCompat queryExecutionCompat = this;
            synchronized (queryExecutionCompat) {
                if (this.qExecHere == null) {
                    this.qExecHere = this.qExecBuilder.build();
                }
            }
        }
    }

    @Override
    public Dataset getDataset() {
        return this.datasetHere;
    }

    @Override
    public Context getContext() {
        return this.qExecBuilder.getContext();
    }

    @Override
    public Query getQuery() {
        if (this.queryHere != null) {
            return this.queryHere;
        }
        this.execution();
        return this.qExecHere.getQuery();
    }

    @Override
    public ResultSet execSelect() {
        this.execution();
        return super.execSelect();
    }

    @Override
    public Model execConstruct() {
        this.execution();
        return super.execConstruct();
    }

    @Override
    public Model execConstruct(Model model) {
        this.execution();
        return super.execConstruct(model);
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        this.execution();
        return super.execConstructTriples();
    }

    @Override
    public Iterator<Quad> execConstructQuads() {
        this.execution();
        return super.execConstructQuads();
    }

    @Override
    public Dataset execConstructDataset() {
        this.execution();
        return super.execConstructDataset();
    }

    @Override
    public Dataset execConstructDataset(Dataset dataset) {
        this.execution();
        return super.execConstructDataset(dataset);
    }

    @Override
    public Model execDescribe() {
        this.execution();
        return super.execDescribe();
    }

    @Override
    public Model execDescribe(Model model) {
        this.execution();
        return super.execDescribe(model);
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        this.execution();
        return super.execDescribeTriples();
    }

    @Override
    public boolean execAsk() {
        this.execution();
        return super.execAsk();
    }

    @Override
    public JsonArray execJson() {
        this.execution();
        return super.execJson();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        this.execution();
        return super.execJsonItems();
    }

    @Override
    public void abort() {
        this.execution();
        super.abort();
    }

    @Override
    public void close() {
        this.execution();
        super.close();
    }

    @Override
    public boolean isClosed() {
        if (this.qExecHere == null) {
            return false;
        }
        return this.qExecHere.isClosed();
    }

    @Override
    public long getTimeout1() {
        return -1L;
    }

    @Override
    public long getTimeout2() {
        return -1L;
    }
}

