/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.arp1.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import org.apache.jena.irix.IRIException;
import org.apache.jena.rdfxml.arp1.FatalParsingErrorException;
import org.apache.jena.rdfxml.arp1.ParseException;
import org.apache.jena.rdfxml.arp1.SAX2RDF;
import org.apache.jena.rdfxml.arp1.impl.WrappedException;
import org.apache.jena.rdfxml.arp1.impl.XMLHandler;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.CharEncoding;
import org.apache.jena.util.JenaXMLInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RDFXMLParser
extends XMLHandler {
    private final XMLReader saxParser;
    private String readerXMLEncoding = null;
    private String xmlEncoding = null;

    private RDFXMLParser(XMLReader rdr) {
        this.saxParser = rdr;
        try {
            SAX2RDF.installHandlers(rdr, this);
        }
        catch (SAXException e2) {
            throw new RuntimeException("Supposedly impossible:", e2);
        }
    }

    public XMLReader getSAXParser() {
        return this.saxParser;
    }

    public static RDFXMLParser create() {
        try {
            XMLReader xmlreader = JenaXMLInput.createXMLReader();
            RDFXMLParser a = new RDFXMLParser(xmlreader);
            a.setEncoding("UTF");
            return a;
        }
        catch (Exception ex) {
            throw new JenaException("Failed to create an RDFXMLParser", ex);
        }
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse(input, input.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputSource input, String base) throws IOException, SAXException {
        this.initParse(base, "");
        SAX2RDF.installHandlers(this.saxParser, this);
        this.initEncodingChecks(input);
        try {
            this.saxParser.parse(input);
        }
        catch (UTFDataFormatException e2) {
            this.generalError(212, e2);
        }
        catch (IOException e3) {
            this.generalError(213, e3);
        }
        catch (ParseException ex) {
            this.saxParser.getErrorHandler().error(ex);
            throw ex;
        }
        catch (IRIException ex) {
            throw ex;
        }
        catch (WrappedException wrapped) {
            wrapped.throwMe();
        }
        catch (FatalParsingErrorException fatalParsingErrorException) {
        }
        finally {
            this.afterParse();
        }
    }

    private void initEncodingChecks(InputSource in) {
        Reader rdr = in.getCharacterStream();
        this.readerXMLEncoding = null;
        this.encodingProblems = false;
        if (rdr != null && rdr instanceof InputStreamReader) {
            String javaEnc = ((InputStreamReader)rdr).getEncoding();
            this.readerXMLEncoding = CharEncoding.create(javaEnc).name();
        }
    }

    protected void setEncoding(String original) throws SAXParseException {
        CharEncoding encodingInfo = CharEncoding.create(original);
        String e2 = encodingInfo.name();
        if (this.xmlEncoding == null) {
            if (e2.equals("UTF") && this.readerXMLEncoding != null && this.readerXMLEncoding.startsWith("UTF")) {
                this.xmlEncoding = this.readerXMLEncoding;
                return;
            }
            this.xmlEncoding = e2;
            if (this.readerXMLEncoding != null && !this.readerXMLEncoding.equalsIgnoreCase(e2)) {
                this.warning(null, 129, "Encoding on InputStreamReader or FileReader does not match that of XML document. Use FileInputStream. [" + this.readerXMLEncoding + " != " + e2 + "]");
                this.encodingProblems = true;
            }
            if (e2.equals("UTF")) {
                return;
            }
            if (!encodingInfo.isIANA()) {
                this.warning(null, encodingInfo.isInNIO() ? 133 : 132, encodingInfo.warningMessage());
            } else if (!original.equalsIgnoreCase(e2)) {
                this.warning(null, 134, "The encoding \"" + original + "\" is not the canonical name at IANA, suggest \"" + e2 + "\" would give more interoperability.");
            }
        }
    }
}

