/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.triple;

import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;

public class TripleTermOps {
    public static NodeValue fnTriple(NodeValue nv1, NodeValue nv2, NodeValue nv3) {
        Node p;
        Node s = nv1.asNode();
        if (ARQ.isStrictMode()) {
            if (s.isTripleTerm()) {
                throw new ExprEvalException("triple: Subject is a triple term: " + String.valueOf(nv1));
            }
            if (!s.isURI() && !s.isBlank()) {
                throw new ExprEvalException("triple: Subject is not a URI or blank node: " + String.valueOf(nv2));
            }
        }
        if (!(p = nv2.asNode()).isURI()) {
            throw new ExprEvalException("triple: Predicate not a URI: " + String.valueOf(nv2));
        }
        Node o = nv3.asNode();
        Node t = NodeFactory.createTripleTerm(s, p, o);
        return NodeValue.makeNode(t);
    }

    public static NodeValue isTriple(NodeValue nv) {
        return NodeValue.booleanReturn(nv.asNode().isTripleTerm());
    }

    private static NodeValue tripleGetter(String name, NodeValue nv, Function<Triple, Node> accessor) {
        Node n = nv.asNode();
        if (!n.isTripleTerm()) {
            throw new ExprEvalException(name + ": Not a triple term: " + String.valueOf(nv));
        }
        Triple t = n.getTriple();
        Node x = accessor.apply(t);
        return NodeValue.makeNode(x);
    }

    public static NodeValue tripleSubject(NodeValue nv) {
        return TripleTermOps.tripleGetter("subject", nv, Triple::getSubject);
    }

    public static NodeValue triplePredicate(NodeValue nv) {
        return TripleTermOps.tripleGetter("predicate", nv, Triple::getPredicate);
    }

    public static NodeValue tripleObject(NodeValue nv) {
        return TripleTermOps.tripleGetter("object", nv, Triple::getObject);
    }
}

