/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.sandbox.facet.FacetFieldCollectorManager;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.iterators.ComparableSupplier;
import org.apache.lucene.sandbox.facet.iterators.LengthOrdinalIterator;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.sandbox.facet.iterators.TopnOrdinalIterator;
import org.apache.lucene.sandbox.facet.labels.OrdToLabel;
import org.apache.lucene.sandbox.facet.recorders.CountFacetRecorder;
import org.apache.lucene.sandbox.facet.utils.ComparableUtils;
import org.apache.lucene.sandbox.facet.utils.FacetBuilder;

abstract class BaseFacetBuilder<C extends BaseFacetBuilder<C>>
extends FacetBuilder {
    final String dimension;
    final String[] path;
    CountFacetRecorder countRecorder;
    private FacetFieldCollectorManager<CountFacetRecorder> collectorManager;
    private int topN = -1;
    Supplier<ComparableSupplier<?>> sortOrderSupplier = () -> ComparableUtils.byCount(this.countRecorder);

    BaseFacetBuilder(String dimension, String ... path) {
        this.dimension = dimension;
        this.path = path;
    }

    public final C withTopN(int n) {
        this.topN = n;
        return this.self();
    }

    public final C withSortByCount() {
        this.sortOrderSupplier = () -> ComparableUtils.byCount(this.countRecorder);
        return this.self();
    }

    final C withSortByOrdinal() {
        this.sortOrderSupplier = ComparableUtils::byOrdinal;
        return this.self();
    }

    abstract FacetCutter getFacetCutter();

    abstract OrdToLabel getOrdToLabel();

    OrdinalIterator getMatchingOrdinalIterator() throws IOException {
        return this.countRecorder.recordedOrds();
    }

    final Number getValue(int facetOrd) {
        return this.countRecorder.getCount(facetOrd);
    }

    abstract Number getOverallValue() throws IOException;

    @Override
    FacetBuilder initOrReuseCollector(FacetBuilder similar) {
        if (similar instanceof BaseFacetBuilder) {
            BaseFacetBuilder castedSimilar = (BaseFacetBuilder)similar;
            this.countRecorder = castedSimilar.countRecorder;
            return similar;
        }
        this.countRecorder = new CountFacetRecorder();
        this.collectorManager = new FacetFieldCollectorManager<CountFacetRecorder>(this.getFacetCutter(), this.countRecorder);
        return this;
    }

    @Override
    final FacetFieldCollectorManager<?> getCollectorManager() {
        return this.collectorManager;
    }

    @Override
    public final FacetResult getResult() {
        assert (this.countRecorder != null) : "must not be called before collect";
        try {
            int[] ordinalsArray;
            LengthOrdinalIterator lengthOrdinalIterator;
            LengthOrdinalIterator ordinalIterator = lengthOrdinalIterator = new LengthOrdinalIterator(this.getMatchingOrdinalIterator());
            ComparableSupplier<?> comparableSupplier = this.sortOrderSupplier.get();
            if (this.topN != -1) {
                ordinalsArray = new TopnOrdinalIterator(ordinalIterator, comparableSupplier, this.topN).toArray();
            } else {
                ordinalsArray = ordinalIterator.toArray();
                ComparableUtils.sort(ordinalsArray, comparableSupplier);
            }
            OrdToLabel ordToLabel = this.getOrdToLabel();
            FacetLabel[] labels = ordToLabel.getLabels(ordinalsArray);
            LabelAndValue[] labelsAndValues = new LabelAndValue[labels.length];
            for (int i = 0; i < ordinalsArray.length; ++i) {
                labelsAndValues[i] = new LabelAndValue(labels[i].lastComponent(), this.getValue(ordinalsArray[i]), this.countRecorder.getCount(ordinalsArray[i]));
            }
            return new FacetResult(this.dimension, this.path, this.getOverallValue(), labelsAndValues, lengthOrdinalIterator.length());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    abstract C self();
}

