/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.thread.Invocable;

public interface Response {
    public Request getRequest();

    public HttpVersion getVersion();

    public int getStatus();

    public String getReason();

    public HttpFields getHeaders();

    public HttpFields getTrailers();

    public CompletableFuture<Boolean> abort(Throwable var1);

    public static interface Listener
    extends BeginListener,
    HeaderListener,
    HeadersListener,
    ContentListener,
    SuccessListener,
    FailureListener,
    CompleteListener {
        @Override
        default public void onBegin(Response response) {
        }

        @Override
        default public boolean onHeader(Response response, HttpField field) {
            return true;
        }

        @Override
        default public void onHeaders(Response response) {
        }

        @Override
        default public void onContent(Response response, ByteBuffer content) {
        }

        @Override
        default public void onSuccess(Response response) {
        }

        @Override
        default public void onFailure(Response response, Throwable failure) {
        }

        @Override
        default public void onComplete(Result result) {
        }
    }

    public static interface CompleteListener
    extends ResponseListener {
        public void onComplete(Result var1);
    }

    public static interface FailureListener
    extends ResponseListener {
        public void onFailure(Response var1, Throwable var2);
    }

    public static interface SuccessListener
    extends ResponseListener {
        public void onSuccess(Response var1);
    }

    public static interface ContentSourceListener
    extends ResponseListener {
        public void onContentSource(Response var1, Content.Source var2);
    }

    public static interface AsyncContentListener
    extends ContentSourceListener {
        public void onContent(Response var1, Content.Chunk var2, Runnable var3) throws Exception;

        @Override
        default public void onContentSource(Response response, Content.Source contentSource) {
            Invocable.InvocationType invocationType = Invocable.getInvocationType(contentSource);
            Invocable.Task demandCallback = Invocable.from(invocationType, () -> this.onContentSource(response, contentSource));
            Content.Chunk chunk = contentSource.read();
            if (chunk == null) {
                contentSource.demand(demandCallback);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                response.abort(chunk.getFailure());
                if (!chunk.isLast()) {
                    contentSource.fail(chunk.getFailure());
                }
                return;
            }
            if (chunk.isLast() && !chunk.hasRemaining()) {
                chunk.release();
                return;
            }
            try {
                this.onContent(response, chunk, () -> contentSource.demand(demandCallback));
                chunk.release();
            }
            catch (Throwable x) {
                chunk.release();
                response.abort(x);
                contentSource.fail(x);
            }
        }
    }

    public static interface ContentListener
    extends AsyncContentListener {
        public void onContent(Response var1, ByteBuffer var2) throws Exception;

        @Override
        default public void onContent(Response response, Content.Chunk chunk, Runnable demander) throws Exception {
            this.onContent(response, chunk.getByteBuffer());
            demander.run();
        }
    }

    public static interface HeadersListener
    extends ResponseListener {
        public void onHeaders(Response var1);
    }

    public static interface HeaderListener
    extends ResponseListener {
        public boolean onHeader(Response var1, HttpField var2);
    }

    public static interface BeginListener
    extends ResponseListener {
        public void onBegin(Response var1);
    }

    public static interface ResponseListener
    extends EventListener {
    }
}

