/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.event.WikiEventEmitter;
import org.apache.wiki.workflow.AbstractStep;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Outcome;

public abstract class Decision
extends AbstractStep {
    private static final long serialVersionUID = -6835601038263238062L;
    private Principal m_actor;
    private int m_id;
    private final Outcome m_defaultOutcome;
    private final List<Fact> m_facts;

    public Decision(int workflowId, Map<String, Serializable> workflowContext, String messageKey, Principal actor, Outcome defaultOutcome) {
        super(workflowId, workflowContext, messageKey);
        this.m_actor = actor;
        this.m_defaultOutcome = defaultOutcome;
        this.m_facts = new ArrayList<Fact>();
        this.addSuccessor(defaultOutcome, null);
    }

    public final void addFact(Fact fact) {
        this.m_facts.add(fact);
    }

    public void decide(Outcome outcome, Context context) throws WikiException {
        super.setOutcome(outcome);
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)70, (Object[])new Object[]{context});
    }

    @Override
    public Outcome execute(Context context) throws WikiException {
        if (this.getOutcome().isCompletion()) {
            return this.getOutcome();
        }
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)60);
        return Outcome.STEP_CONTINUE;
    }

    @Override
    public final Principal getActor() {
        return this.m_actor;
    }

    public Outcome getDefaultOutcome() {
        return this.m_defaultOutcome;
    }

    public final List<Fact> getFacts() {
        return Collections.unmodifiableList(this.m_facts);
    }

    public final int getId() {
        return this.m_id;
    }

    public boolean isReassignable() {
        return true;
    }

    public final synchronized void reassign(Principal actor) {
        if (!this.isReassignable()) {
            throw new IllegalArgumentException("Decision cannot be reassigned.");
        }
        this.m_actor = actor;
    }

    public final void setId(int id) {
        this.m_id = id;
    }
}

