/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.MediaType;
import org.apache.juneau.bean.swagger.ExternalDocumentation;
import org.apache.juneau.bean.swagger.Info;
import org.apache.juneau.bean.swagger.Operation;
import org.apache.juneau.bean.swagger.OperationMap;
import org.apache.juneau.bean.swagger.ParameterInfo;
import org.apache.juneau.bean.swagger.ResponseInfo;
import org.apache.juneau.bean.swagger.SecurityScheme;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.bean.swagger.Tag;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.objecttools.ObjectRest;

public class Swagger
extends SwaggerElement {
    public static final Swagger NULL = new Swagger();
    private static final Comparator<String> PATH_COMPARATOR = (o1, o2) -> o1.replace('{', '@').compareTo(o2.replace('{', '@'));
    private String swagger = "2.0";
    private String host;
    private String basePath;
    private Info info;
    private ExternalDocumentation externalDocs;
    private Set<String> schemes = new LinkedHashSet<String>();
    private Set<MediaType> consumes = new LinkedHashSet<MediaType>();
    private Set<MediaType> produces = new LinkedHashSet<MediaType>();
    private Set<Tag> tags = new LinkedHashSet<Tag>();
    private List<Map<String, List<String>>> security = CollectionUtils.list((Object[])new Map[0]);
    private Map<String, JsonMap> definitions = CollectionUtils.map();
    private Map<String, ParameterInfo> parameters = CollectionUtils.map();
    private Map<String, ResponseInfo> responses = CollectionUtils.map();
    private Map<String, SecurityScheme> securityDefinitions = CollectionUtils.map();
    private Map<String, OperationMap> paths = new TreeMap<String, OperationMap>(PATH_COMPARATOR);

    public Swagger() {
    }

    public Swagger(Swagger copyFrom) {
        super(copyFrom);
        this.basePath = copyFrom.basePath;
        if (Utils.nn(copyFrom.consumes)) {
            this.consumes.addAll(CollectionUtils.copyOf(copyFrom.consumes));
        }
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.host = copyFrom.host;
        Info info = this.info = copyFrom.info == null ? null : copyFrom.info.copy();
        if (Utils.nn(copyFrom.produces)) {
            this.produces.addAll(CollectionUtils.copyOf(copyFrom.produces));
        }
        if (Utils.nn(copyFrom.schemes)) {
            this.schemes.addAll(CollectionUtils.copyOf(copyFrom.schemes));
        }
        this.swagger = copyFrom.swagger;
        if (Utils.nn(copyFrom.definitions)) {
            this.definitions.putAll(CollectionUtils.copyOf(copyFrom.definitions, JsonMap::new));
        }
        if (Utils.nn(copyFrom.paths)) {
            copyFrom.paths.forEach((k, v) -> {
                OperationMap m = new OperationMap();
                v.forEach((k2, v2) -> m.put((String)k2, v2.copy()));
                this.paths.put((String)k, m);
            });
        }
        if (Utils.nn(copyFrom.parameters)) {
            this.parameters.putAll(CollectionUtils.copyOf(copyFrom.parameters, ParameterInfo::copy));
        }
        if (Utils.nn(copyFrom.responses)) {
            this.responses.putAll(CollectionUtils.copyOf(copyFrom.responses, ResponseInfo::copy));
        }
        if (Utils.nn(copyFrom.securityDefinitions)) {
            this.securityDefinitions.putAll(CollectionUtils.copyOf(copyFrom.securityDefinitions, SecurityScheme::copy));
        }
        if (Utils.nn(copyFrom.security)) {
            copyFrom.security.forEach(x -> {
                LinkedHashMap m2 = CollectionUtils.map();
                x.forEach((k, v) -> m2.put(k, CollectionUtils.copyOf((List)v)));
                this.security.add(m2);
            });
        }
        if (Utils.nn(copyFrom.tags)) {
            this.tags.addAll(CollectionUtils.copyOf(copyFrom.tags, x -> x.copy()));
        }
    }

    public Swagger addConsumes(Collection<MediaType> values) {
        if (Utils.nn(values)) {
            this.consumes.addAll(values);
        }
        return this;
    }

    public Swagger addConsumes(MediaType ... values) {
        if (Utils.nn((Object)values)) {
            for (MediaType v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.consumes.add(v);
            }
        }
        return this;
    }

    public Swagger addDefinition(String name, JsonMap schema) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"schema", (Object)schema);
        this.definitions.put(name, schema);
        return this;
    }

    public Swagger addParameter(String name, ParameterInfo parameter) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"parameter", (Object)parameter);
        this.parameters.put(name, parameter);
        return this;
    }

    public Swagger addPath(String path, String methodName, Operation operation) {
        AssertionUtils.assertArgNotNull((String)"path", (Object)path);
        AssertionUtils.assertArgNotNull((String)"methodName", (Object)methodName);
        AssertionUtils.assertArgNotNull((String)"operation", (Object)operation);
        this.paths.computeIfAbsent(path, k -> new OperationMap()).put(methodName, operation);
        return this;
    }

    public Swagger addProduces(Collection<MediaType> values) {
        if (Utils.nn(values)) {
            this.produces.addAll(values);
        }
        return this;
    }

    public Swagger addProduces(MediaType ... values) {
        if (Utils.nn((Object)values)) {
            for (MediaType v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.produces.add(v);
            }
        }
        return this;
    }

    public Swagger addResponse(String name, ResponseInfo response) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"response", (Object)response);
        this.responses.put(name, response);
        return this;
    }

    public Swagger addSchemes(Collection<String> values) {
        if (Utils.nn(values)) {
            this.schemes.addAll(values);
        }
        return this;
    }

    public Swagger addSchemes(String ... values) {
        if (Utils.nn((Object)values)) {
            for (String v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.schemes.add(v);
            }
        }
        return this;
    }

    public Swagger addSecurity(Collection<Map<String, List<String>>> values) {
        if (Utils.nn(values)) {
            this.security.addAll(values);
        }
        return this;
    }

    public Swagger addSecurity(String scheme, String ... alternatives) {
        AssertionUtils.assertArgNotNull((String)"scheme", (Object)scheme);
        LinkedHashMap m = CollectionUtils.map();
        m.put(scheme, CollectionUtils.l((Object[])alternatives));
        this.security.add(m);
        return this;
    }

    public Swagger addSecurityDefinition(String name, SecurityScheme securityScheme) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"securityScheme", (Object)securityScheme);
        this.securityDefinitions.put(name, securityScheme);
        return this;
    }

    public Swagger addTags(Collection<Tag> values) {
        if (Utils.nn(values)) {
            this.tags.addAll(values);
        }
        return this;
    }

    public Swagger addTags(Tag ... values) {
        if (Utils.nn((Object)values)) {
            for (Tag v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.tags.add(v);
            }
        }
        return this;
    }

    public String asJson() {
        return this.toString();
    }

    public Swagger copy() {
        return new Swagger(this);
    }

    public <T> T findRef(String ref, Class<T> c) {
        AssertionUtils.assertArgNotNullOrBlank((String)"ref", (String)ref);
        AssertionUtils.assertArgNotNull((String)"c", c);
        if (!ref.startsWith("#/")) {
            throw ThrowableUtils.rex((String)"Unsupported reference:  ''{0}''", (Object[])new Object[]{ref});
        }
        try {
            return (T)new ObjectRest((Object)this).get(ref.substring(1), c);
        }
        catch (Exception e) {
            throw ThrowableUtils.bex((Throwable)e, c, (String)"Reference ''{0}'' could not be converted to type ''{1}''.", (Object[])new Object[]{ref, Utils.cn(c)});
        }
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "basePath" -> ConverterUtils.toType((Object)this.getBasePath(), type);
            case "consumes" -> ConverterUtils.toType(this.getConsumes(), type);
            case "definitions" -> ConverterUtils.toType(this.getDefinitions(), type);
            case "externalDocs" -> ConverterUtils.toType((Object)this.getExternalDocs(), type);
            case "host" -> ConverterUtils.toType((Object)this.getHost(), type);
            case "info" -> ConverterUtils.toType((Object)this.getInfo(), type);
            case "parameters" -> ConverterUtils.toType(this.getParameters(), type);
            case "paths" -> ConverterUtils.toType(this.getPaths(), type);
            case "produces" -> ConverterUtils.toType(this.getProduces(), type);
            case "responses" -> ConverterUtils.toType(this.getResponses(), type);
            case "schemes" -> ConverterUtils.toType(this.getSchemes(), type);
            case "security" -> ConverterUtils.toType(this.getSecurity(), type);
            case "securityDefinitions" -> ConverterUtils.toType(this.getSecurityDefinitions(), type);
            case "swagger" -> ConverterUtils.toType((Object)this.getSwagger(), type);
            case "tags" -> ConverterUtils.toType(this.getTags(), type);
            default -> super.get(property, type);
        });
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Set<MediaType> getConsumes() {
        return Utils.nullIfEmpty(this.consumes);
    }

    public Map<String, JsonMap> getDefinitions() {
        return Utils.nullIfEmpty(this.definitions);
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getHost() {
        return this.host;
    }

    public Info getInfo() {
        return this.info;
    }

    public Operation getOperation(String path, String operation) {
        AssertionUtils.assertArgNotNull((String)"path", (Object)path);
        AssertionUtils.assertArgNotNull((String)"operation", (Object)operation);
        return Utils.opt((Object)this.getPath(path)).map(x -> (Operation)x.get(operation)).orElse(null);
    }

    public ParameterInfo getParameterInfo(String path, String method, String in, String name) {
        AssertionUtils.assertArgNotNull((String)"path", (Object)path);
        AssertionUtils.assertArgNotNull((String)"method", (Object)method);
        AssertionUtils.assertArgNotNull((String)"in", (Object)in);
        return Utils.opt((Object)this.getPath(path)).map(x -> (Operation)x.get(method)).map(x -> x.getParameter(in, name)).orElse(null);
    }

    public Map<String, ParameterInfo> getParameters() {
        return Utils.nullIfEmpty(this.parameters);
    }

    public OperationMap getPath(String path) {
        AssertionUtils.assertArgNotNull((String)"path", (Object)path);
        return Utils.opt(this.getPaths()).map(x -> (OperationMap)x.get(path)).orElse(null);
    }

    public Map<String, OperationMap> getPaths() {
        return Utils.nullIfEmpty(this.paths);
    }

    public Set<MediaType> getProduces() {
        return Utils.nullIfEmpty(this.produces);
    }

    public ResponseInfo getResponseInfo(String path, String operation, int status) {
        return this.getResponseInfo(path, operation, String.valueOf(status));
    }

    public ResponseInfo getResponseInfo(String path, String operation, String status) {
        AssertionUtils.assertArgNotNull((String)"path", (Object)path);
        AssertionUtils.assertArgNotNull((String)"operation", (Object)operation);
        AssertionUtils.assertArgNotNull((String)"status", (Object)status);
        return Utils.opt((Object)this.getPath(path)).map(x -> (Operation)x.get(operation)).map(x -> x.getResponse(status)).orElse(null);
    }

    public Map<String, ResponseInfo> getResponses() {
        return Utils.nullIfEmpty(this.responses);
    }

    public Set<String> getSchemes() {
        return Utils.nullIfEmpty(this.schemes);
    }

    public List<Map<String, List<String>>> getSecurity() {
        return Utils.nullIfEmpty(this.security);
    }

    public Map<String, SecurityScheme> getSecurityDefinitions() {
        return Utils.nullIfEmpty(this.securityDefinitions);
    }

    public String getSwagger() {
        return this.swagger;
    }

    public Set<Tag> getTags() {
        return Utils.nullIfEmpty(this.tags);
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.basePath), (Object)"basePath").addIf(Utils.ne(this.consumes), (Object)"consumes").addIf(Utils.ne(this.definitions), (Object)"definitions").addIf(Utils.nn((Object)this.externalDocs), (Object)"externalDocs").addIf(Utils.nn((Object)this.host), (Object)"host").addIf(Utils.nn((Object)this.info), (Object)"info").addIf(Utils.ne(this.parameters), (Object)"parameters").addIf(Utils.ne(this.paths), (Object)"paths").addIf(Utils.ne(this.produces), (Object)"produces").addIf(Utils.ne(this.responses), (Object)"responses").addIf(Utils.ne(this.schemes), (Object)"schemes").addIf(Utils.ne(this.security), (Object)"security").addIf(Utils.ne(this.securityDefinitions), (Object)"securityDefinitions").addIf(Utils.nn((Object)this.swagger), (Object)"swagger").addIf(Utils.ne(this.tags), (Object)"tags").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Swagger set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "basePath" -> this.setBasePath(Utils.s((Object)value));
            case "consumes" -> this.setConsumes(ConverterUtils.toListBuilder((Object)value, MediaType.class).sparse().build());
            case "definitions" -> this.setDefinitions(ConverterUtils.toMapBuilder((Object)value, String.class, JsonMap.class).sparse().build());
            case "externalDocs" -> this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            case "host" -> this.setHost(Utils.s((Object)value));
            case "info" -> this.setInfo((Info)ConverterUtils.toType((Object)value, Info.class));
            case "parameters" -> this.setParameters(ConverterUtils.toMapBuilder((Object)value, String.class, ParameterInfo.class).sparse().build());
            case "paths" -> this.setPaths(ConverterUtils.toMapBuilder((Object)value, String.class, OperationMap.class).sparse().build());
            case "produces" -> this.setProduces(ConverterUtils.toListBuilder((Object)value, MediaType.class).sparse().build());
            case "responses" -> this.setResponses(ConverterUtils.toMapBuilder((Object)value, String.class, ResponseInfo.class).sparse().build());
            case "schemes" -> this.setSchemes(ConverterUtils.toListBuilder((Object)value, String.class).sparse().build());
            case "security" -> this.setSecurity(ConverterUtils.toListBuilder((Object)value, MapOfStringLists.class).sparse().build());
            case "securityDefinitions" -> this.setSecurityDefinitions(ConverterUtils.toMapBuilder((Object)value, String.class, SecurityScheme.class).sparse().build());
            case "swagger" -> this.setSwagger(Utils.s((Object)value));
            case "tags" -> this.setTags(ConverterUtils.toListBuilder((Object)value, Tag.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Swagger setBasePath(String value) {
        this.basePath = value;
        return this;
    }

    public Swagger setConsumes(Collection<MediaType> value) {
        this.consumes.clear();
        if (Utils.nn(value)) {
            this.consumes.addAll(value);
        }
        return this;
    }

    public Swagger setConsumes(MediaType ... value) {
        this.setConsumes(CollectionUtils.setb(MediaType.class).sparse().add((Object[])value).build());
        return this;
    }

    public Swagger setDefinitions(Map<String, JsonMap> value) {
        this.definitions.clear();
        if (Utils.nn(value)) {
            this.definitions.putAll(value);
        }
        return this;
    }

    public Swagger setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Swagger setHost(String value) {
        this.host = value;
        return this;
    }

    public Swagger setInfo(Info value) {
        this.info = value;
        return this;
    }

    public Swagger setParameters(Map<String, ParameterInfo> value) {
        this.parameters.clear();
        if (Utils.nn(value)) {
            this.parameters.putAll(value);
        }
        return this;
    }

    public Swagger setPaths(Map<String, OperationMap> value) {
        this.paths.clear();
        if (Utils.nn(value)) {
            this.paths.putAll(value);
        }
        return this;
    }

    public Swagger setProduces(Collection<MediaType> value) {
        this.produces.clear();
        if (Utils.nn(value)) {
            this.produces.addAll(value);
        }
        return this;
    }

    public Swagger setProduces(MediaType ... value) {
        this.setProduces(CollectionUtils.setb(MediaType.class).sparse().add((Object[])value).build());
        return this;
    }

    public Swagger setResponses(Map<String, ResponseInfo> value) {
        this.responses.clear();
        if (Utils.nn(value)) {
            this.responses.putAll(value);
        }
        return this;
    }

    public Swagger setSchemes(Collection<String> value) {
        this.schemes.clear();
        if (Utils.nn(value)) {
            this.schemes.addAll(value);
        }
        return this;
    }

    public Swagger setSchemes(String ... value) {
        this.setSchemes(CollectionUtils.setb(String.class).sparse().addJson(value).build());
        return this;
    }

    public Swagger setSecurity(Collection<Map<String, List<String>>> value) {
        this.security.clear();
        if (Utils.nn(value)) {
            this.security.addAll(value);
        }
        return this;
    }

    public Swagger setSecurityDefinitions(Map<String, SecurityScheme> value) {
        this.securityDefinitions.clear();
        if (Utils.nn(value)) {
            this.securityDefinitions.putAll(value);
        }
        return this;
    }

    public Swagger setSwagger(String value) {
        this.swagger = value;
        return this;
    }

    public Swagger setTags(Collection<Tag> value) {
        this.tags.clear();
        if (Utils.nn(value)) {
            this.tags.addAll(value);
        }
        return this;
    }

    public Swagger setTags(Tag ... value) {
        this.setTags(CollectionUtils.setb(Tag.class).sparse().add((Object[])value).build());
        return this;
    }

    @Override
    public Swagger strict() {
        super.strict();
        return this;
    }

    @Override
    public Swagger strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    public String toString() {
        return JsonSerializer.DEFAULT.toString((Object)this);
    }

    private static interface MapOfStringLists
    extends Map<String, List<String>> {
    }
}

