/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.MediaType;
import org.apache.juneau.bean.html5.Div;
import org.apache.juneau.bean.html5.HtmlBuilder;
import org.apache.juneau.bean.html5.HtmlElement;
import org.apache.juneau.bean.html5.Select;
import org.apache.juneau.bean.html5.Span;
import org.apache.juneau.bean.html5.Table;
import org.apache.juneau.bean.html5.Td;
import org.apache.juneau.bean.swagger.Contact;
import org.apache.juneau.bean.swagger.ExternalDocumentation;
import org.apache.juneau.bean.swagger.Info;
import org.apache.juneau.bean.swagger.License;
import org.apache.juneau.bean.swagger.Operation;
import org.apache.juneau.bean.swagger.ParameterInfo;
import org.apache.juneau.bean.swagger.ResponseInfo;
import org.apache.juneau.bean.swagger.SchemaInfo;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.Tag;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.swap.ObjectSwap;

public class SwaggerUI
extends ObjectSwap<Swagger, Div> {
    static final FileFinder RESOURCES = (FileFinder)FileFinder.create(BeanStore.INSTANCE).cp(SwaggerUI.class, null, true).dir(",").caching(Boolean.getBoolean("RestContext.disableClasspathResourceCaching.b") ? -1L : 1000000L).build();
    private static final Set<String> STANDARD_METHODS = CollectionUtils.set("get", "put", "post", "delete", "options");

    private static Div examples(Session s, ParameterInfo pi) {
        boolean isBody = "body".equals(pi.getIn());
        JsonMap m = new JsonMap();
        try {
            if (isBody) {
                SchemaInfo si = pi.getSchema();
                if (Utils.nn(si)) {
                    m.put("model", (Object)si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth));
                }
            } else {
                JsonMap m2 = pi.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth).asMap().keepAll("format", "pattern", "collectionFormat", "maximum", "minimum", "multipleOf", "maxLength", "minLength", "maxItems", "minItems", "allowEmptyValue", "exclusiveMaximum", "exclusiveMinimum", "uniqueItems", "items", "default", "enum");
                m.put("model", m2.isEmpty() ? HtmlBuilder.i("none") : m2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return SwaggerUI.examplesDiv(m);
    }

    private static Div examples(Session s, ResponseInfo ri) {
        SchemaInfo si = ri.getSchema();
        JsonMap m = new JsonMap();
        try {
            Map<String, Object> examples;
            if (Utils.nn(si)) {
                si = si.copy().resolveRefs(s.swagger, new ArrayDeque<String>(), s.resolveRefsMaxDepth);
                m.put("model", (Object)si);
            }
            if (Utils.nn(examples = ri.getExamples())) {
                examples.forEach(m::put);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return SwaggerUI.examplesDiv(m);
    }

    private static Div examplesDiv(JsonMap m) {
        if (m.isEmpty()) {
            return null;
        }
        Select select = null;
        if (m.size() > 1) {
            select = HtmlBuilder.select().onchange("selectExample(this)")._class("example-select");
        }
        Div div = HtmlBuilder.div(select)._class("examples");
        if (Utils.nn(select)) {
            select.child(HtmlBuilder.option("model", "model"));
        }
        div.child(HtmlBuilder.div(m.remove("model"))._class("model active").attr("data-name", "model"));
        Select select2 = select;
        m.forEach((k, v) -> {
            if (Utils.nn(select2)) {
                select2.child(HtmlBuilder.option(k, k));
            }
            div.child(HtmlBuilder.div(v.toString().replace("\\n", "\n"))._class("example").attr("data-name", k));
        });
        return div;
    }

    private static Table header(Session s) {
        Table table = HtmlBuilder.table()._class("header");
        Info info = s.swagger.getInfo();
        if (Utils.nn(info)) {
            String child;
            ExternalDocumentation ed;
            License l;
            Contact c;
            if (Utils.nn(info.getDescription())) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Description:"), HtmlBuilder.td(SwaggerUI.toBRL(info.getDescription()))));
            }
            if (Utils.nn(info.getVersion())) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Version:"), HtmlBuilder.td(info.getVersion())));
            }
            if (Utils.nn(c = info.getContact())) {
                Table t2 = HtmlBuilder.table();
                if (Utils.nn(c.getName())) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Name:"), HtmlBuilder.td(c.getName())));
                }
                if (Utils.nn(c.getUrl())) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("URL:"), HtmlBuilder.td(HtmlBuilder.a(c.getUrl(), c.getUrl()))));
                }
                if (Utils.nn(c.getEmail())) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Email:"), HtmlBuilder.td(HtmlBuilder.a("mailto:" + c.getEmail(), c.getEmail()))));
                }
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Contact:"), HtmlBuilder.td(t2)));
            }
            if (Utils.nn(l = info.getLicense())) {
                Object content = Utils.nn(l.getName()) ? l.getName() : l.getUrl();
                String child2 = Utils.nn(l.getUrl()) ? HtmlBuilder.a(l.getUrl(), content) : l.getName();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("License:"), HtmlBuilder.td(child2)));
            }
            if (Utils.nn(ed = s.swagger.getExternalDocs())) {
                Object content = Utils.nn(ed.getDescription()) ? ed.getDescription() : ed.getUrl();
                child = Utils.nn(ed.getUrl()) ? HtmlBuilder.a(ed.getUrl(), content) : ed.getDescription();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Docs:"), HtmlBuilder.td(child)));
            }
            if (Utils.nn(info.getTermsOfService())) {
                String tos = info.getTermsOfService();
                child = StringUtils.isUri(tos) ? HtmlBuilder.a(tos, tos) : tos;
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Terms of Service:"), HtmlBuilder.td(child)));
            }
        }
        return table;
    }

    private static Div headers(ResponseInfo ri) {
        if (ri.getHeaders() == null) {
            return null;
        }
        Table sectionTable = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name"), HtmlBuilder.th("Description"), HtmlBuilder.th("Schema")))._class("section-table");
        Div headers = HtmlBuilder.div(HtmlBuilder.div("Headers:")._class("section-name"), sectionTable)._class("headers");
        ri.getHeaders().forEach((k, v) -> sectionTable.child(HtmlBuilder.tr(HtmlBuilder.td(k)._class("name"), HtmlBuilder.td(SwaggerUI.toBRL(v.getDescription()))._class("description"), HtmlBuilder.td(v.asMap().keepAll("type", "format", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf")))));
        return headers;
    }

    private static Div modelBlock(String modelName, JsonMap model) {
        return HtmlBuilder.div()._class("op-block op-block-closed model").children(SwaggerUI.modelBlockSummary(modelName, model), HtmlBuilder.div(model)._class("op-block-contents"));
    }

    private static HtmlElement modelBlockSummary(String modelName, JsonMap model) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(HtmlBuilder.span(modelName)._class("method-button"), model.containsKey("description") ? HtmlBuilder.span(SwaggerUI.toBRL(model.remove("description").toString()))._class("summary") : null);
    }

    private static Div modelsBlockContents(Session s) {
        Div modelBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        s.swagger.getDefinitions().forEach((k, v) -> modelBlockContents.child(SwaggerUI.modelBlock(k, v)));
        return modelBlockContents;
    }

    private static HtmlElement modelsBlockSummary() {
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(HtmlBuilder.span("Models")._class("name"));
    }

    private static Div opBlock(Session s, String path, String opName, Operation op) {
        String opClass;
        String string = opClass = op.isDeprecated() ? "deprecated" : opName.toLowerCase();
        if (!op.isDeprecated() && !STANDARD_METHODS.contains(opClass)) {
            opClass = "other";
        }
        return HtmlBuilder.div()._class("op-block op-block-closed " + opClass).children(SwaggerUI.opBlockSummary(path, opName, op), HtmlBuilder.div(SwaggerUI.tableContainer(s, op))._class("op-block-contents"));
    }

    private static HtmlElement opBlockSummary(String path, String opName, Operation op) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(HtmlBuilder.span(opName.toUpperCase())._class("method-button"), HtmlBuilder.span(path)._class("path"), Utils.nn(op.getSummary()) ? HtmlBuilder.span(op.getSummary())._class("summary") : null);
    }

    private static Div tableContainer(Session s, Operation op) {
        Div tableContainer = HtmlBuilder.div()._class("table-container");
        if (Utils.nn(op.getDescription())) {
            tableContainer.child(HtmlBuilder.div(SwaggerUI.toBRL(op.getDescription()))._class("op-block-description"));
        }
        if (Utils.nn(op.getParameters())) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Parameters")._class("title"))._class("op-block-section-header"));
            Table parameters = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name")._class("parameter-key"), HtmlBuilder.th("Description")._class("parameter-key")))._class("parameters");
            op.getParameters().forEach(x -> {
                String piName = "body".equals(x.getIn()) ? "body" : x.getName();
                boolean required = Utils.nn(x.getRequired()) && x.getRequired() != false;
                Td parameterKey = HtmlBuilder.td(HtmlBuilder.div(piName)._class("name" + (required ? " required" : "")), required ? HtmlBuilder.div("required")._class("requiredlabel") : null, HtmlBuilder.div(x.getType())._class("type"), HtmlBuilder.div("(" + x.getIn() + ")")._class("in"))._class("parameter-key");
                Td parameterValue = HtmlBuilder.td(HtmlBuilder.div(SwaggerUI.toBRL(x.getDescription()))._class("description"), SwaggerUI.examples(s, x))._class("parameter-value");
                parameters.child(HtmlBuilder.tr(parameterKey, parameterValue));
            });
            tableContainer.child(parameters);
        }
        if (Utils.nn(op.getResponses())) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Responses")._class("title"))._class("op-block-section-header"));
            Table responses = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Code")._class("response-key"), HtmlBuilder.th("Description")._class("response-key")))._class("responses");
            tableContainer.child(responses);
            op.getResponses().forEach((k, v) -> {
                Td code = HtmlBuilder.td(k)._class("response-key");
                Td codeValue = HtmlBuilder.td(HtmlBuilder.div(SwaggerUI.toBRL(v.getDescription()))._class("description"), SwaggerUI.examples(s, v), SwaggerUI.headers(v))._class("response-value");
                responses.child(HtmlBuilder.tr(code, codeValue));
            });
        }
        return tableContainer;
    }

    private static Div tagBlockContents(Session s, Tag t) {
        Div tagBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        if (Utils.nn(s.swagger.getPaths())) {
            s.swagger.getPaths().forEach((path, v) -> v.forEach((opName, op) -> {
                if (t == null && op.getTags() == null || Utils.nn(t) && Utils.nn(op.getTags()) && op.getTags().contains(t.getName())) {
                    tagBlockContents.child(SwaggerUI.opBlock(s, path, opName, op));
                }
            }));
        }
        return tagBlockContents;
    }

    private static HtmlElement tagBlockSummary(Tag t) {
        ExternalDocumentation ed = t.getExternalDocs();
        ArrayList<Span> children = new ArrayList<Span>();
        children.add(HtmlBuilder.span(t.getName())._class("name"));
        children.add(HtmlBuilder.span(SwaggerUI.toBRL(t.getDescription()))._class("description"));
        if (Utils.nn(ed)) {
            Object content = Utils.nn(ed.getDescription()) ? ed.getDescription() : ed.getUrl();
            children.add(HtmlBuilder.span(HtmlBuilder.a(ed.getUrl(), content))._class("extdocs"));
        }
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(children);
    }

    private static List<Object> toBRL(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(s);
        }
        List<Object> l = CollectionUtils.list(new Object[0]);
        String[] sa = s.split("\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                l.add(HtmlBuilder.br());
            }
            l.add(sa[i]);
        }
        return l;
    }

    @Override
    public MediaType[] forMediaTypes() {
        return CollectionUtils.a(MediaType.HTML);
    }

    @Override
    public Div swap(BeanSession beanSession, Swagger swagger) throws Exception {
        Session s = new Session(swagger);
        String css = RESOURCES.getString("files/htdocs/styles/SwaggerUI.css", null).orElse(null);
        if (css == null) {
            css = RESOURCES.getString("SwaggerUI.css", null).orElse(null);
        }
        Div outer = HtmlBuilder.div(HtmlBuilder.style((Object)css), HtmlBuilder.script("text/javascript", RESOURCES.getString("SwaggerUI.js", null).orElse(null)), SwaggerUI.header(s))._class("swagger-ui");
        outer.child(HtmlBuilder.div()._class("tag-block tag-block-open").children(SwaggerUI.tagBlockContents(s, null)));
        if (Utils.nn(s.swagger.getTags())) {
            s.swagger.getTags().forEach(x -> {
                Div tagBlock = HtmlBuilder.div()._class("tag-block tag-block-open").children(SwaggerUI.tagBlockSummary(x), SwaggerUI.tagBlockContents(s, x));
                outer.child(tagBlock);
            });
        }
        if (Utils.nn(s.swagger.getDefinitions())) {
            Div modelBlock = HtmlBuilder.div()._class("tag-block").children(SwaggerUI.modelsBlockSummary(), SwaggerUI.modelsBlockContents(s));
            outer.child(modelBlock);
        }
        return outer;
    }

    private static class Session {
        final int resolveRefsMaxDepth;
        final Swagger swagger;

        Session(Swagger swagger) {
            this.swagger = swagger.copy();
            this.resolveRefsMaxDepth = 1;
        }
    }
}

